/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.tradelog.repository.adapters;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.database.migrations.mysql.MySQLConnection;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.extras.tradelog.repository.TradeLogRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MysqlTradeLogRepository
implements TradeLogRepository {
    @Override
    public void registerOrUpdatePlayer(@NotNull UUID uuid, @NotNull String name) throws SQLException {
        String sql = "INSERT INTO trade_players(uuid, name) VALUES(?,?) ON DUPLICATE KEY UPDATE name=?;";
        try (Connection con = MySQLConnection.getConnection().get();
             PreparedStatement pstmt = con.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, name);
            pstmt.setString(3, name);
            pstmt.executeUpdate();
        }
    }

    @Override
    public void log(String player1, String player2, String message) {
        String sql = "INSERT INTO tradelog(player1, player2, message) VALUES(?,?,?);";
        try (Connection con = MySQLConnection.getConnection().get();
             PreparedStatement pstmt = con.prepareStatement(sql);){
            pstmt.setString(1, player1);
            pstmt.setString(2, player2);
            pstmt.setString(3, message);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            TradeSystem.getInstance().getLogger().severe("Could not log player '" + player1 + "' with player '" + player2 + "' ('" + message + "'): " + e.getMessage() + " [MySQL]");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long count(String player, String message) {
        String sql = "SELECT COUNT(1) as count FROM tradelog WHERE (player1=? OR player2=?) AND message like ?;";
        try (Connection con = MySQLConnection.getConnection().get();){
            long l;
            block14: {
                PreparedStatement pstmt = con.prepareStatement(sql);
                try {
                    pstmt.setString(1, player);
                    pstmt.setString(2, player);
                    pstmt.setString(3, message);
                    ResultSet set = pstmt.executeQuery();
                    long l2 = l = set.next() ? set.getLong("count") : 0L;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return l;
        }
        catch (SQLException e) {
            TradeSystem.getInstance().getLogger().severe("Could not count player '" + player + "' with message '" + message + "': " + e.getMessage() + " [MySQL]");
            return 0L;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public List<TradeLog.Entry> getLogMessages(String playerName) {
        String sql = "SELECT id, player1, player2, message, timestamp FROM tradelog WHERE player1=? OR player2=? ORDER BY timestamp DESC LIMIT 40;";
        try (Connection con = MySQLConnection.getConnection().get();){
            ArrayList<TradeLog.Entry> arrayList;
            block15: {
                PreparedStatement pstmt = con.prepareStatement(sql);
                try {
                    pstmt.setString(1, playerName);
                    pstmt.setString(2, playerName);
                    ResultSet rs = pstmt.executeQuery();
                    ArrayList<TradeLog.Entry> result = new ArrayList<TradeLog.Entry>();
                    while (rs.next()) {
                        result.add(new TradeLog.Entry(rs.getString(2), rs.getString(3), rs.getString(4), Instant.ofEpochMilli(rs.getDate(5).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()));
                    }
                    arrayList = result;
                    if (pstmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            TradeSystem.getInstance().getLogger().severe("Could not access log messages for player '" + playerName + "': " + e.getMessage() + " [MySQL]");
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean haveTraded(String player1, String player2) {
        String sql = "SELECT 1 FROM tradelog WHERE player1=? AND player2=? OR player1=? AND player2=? LIMIT 1;";
        try (Connection con = MySQLConnection.getConnection().get();){
            boolean bl;
            block14: {
                PreparedStatement pstmt = con.prepareStatement(sql);
                try {
                    pstmt.setString(1, player1);
                    pstmt.setString(2, player2);
                    pstmt.setString(3, player2);
                    pstmt.setString(4, player1);
                    ResultSet rs = pstmt.executeQuery();
                    bl = rs.next();
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            TradeSystem.getInstance().getLogger().severe("Could not check have traded '" + player1 + "' & '" + player2 + "': " + e.getMessage() + " [MySQL]");
            return false;
        }
    }
}

