/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.tradelog;

import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.database.DatabaseType;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.extras.tradelog.repository.TradeLogRepository;
import de.codingair.tradesystem.spigot.extras.tradelog.repository.adapters.MysqlTradeLogRepository;
import de.codingair.tradesystem.spigot.extras.tradelog.repository.adapters.SqlLiteTradeLogRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class TradeLogService {
    private static TradeLogService instance;
    private final boolean bukkitLogger = TradeSystem.getInstance().getFileManager().getFile("Config").getConfig().getBoolean("TradeSystem.TradeLog.Bukkit_logger", false);

    private TradeLogService() {
    }

    private static TradeLogService getTradeLog() {
        if (instance == null) {
            instance = new TradeLogService();
        }
        return instance;
    }

    public static void registerOrUpdatePlayer(@NotNull UUID uniqueId, @NotNull String name) {
        if (!TradeLogService.connected()) {
            return;
        }
        try {
            TradeLogService.getTradeLogRepository().registerOrUpdatePlayer(uniqueId, name);
        }
        catch (Exception e) {
            TradeSystem.getInstance().getLogger().severe("Failed to register or update player information: " + e.getMessage());
        }
    }

    public static long count(@NotNull String player, @NotNull String message) {
        if (!TradeLogService.connected()) {
            return 0L;
        }
        return TradeLogService.getTradeLogRepository().count(player, message);
    }

    public static void log(@NotNull String player1, @NotNull String player2, @Nullable String message) {
        TradeLogService.logLater(player1, player2, message, 0L);
    }

    public static void logLater(@NotNull String player1, @NotNull String player2, @Nullable String message, long delay) {
        if (message == null || !TradeLogService.connected()) {
            return;
        }
        Runnable runnable = () -> {
            if (TradeLogService.getTradeLog().bukkitLogger) {
                Bukkit.getLogger().info("TradeLog [" + player1 + ", " + player2 + "] " + message);
            }
            TradeLogService.getTradeLogRepository().log(player1, player2, message);
        };
        if (TradeSystem.getInstance().isEnabled()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)TradeSystem.getInstance(), runnable, delay);
        } else {
            runnable.run();
        }
    }

    public static List<TradeLog.Entry> getLogMessages(String playerName) {
        if (!TradeLogService.connected()) {
            return new ArrayList<TradeLog.Entry>();
        }
        return TradeLogService.getTradeLogRepository().getLogMessages(playerName);
    }

    public static boolean haveTraded(@NotNull String player1, @NotNull String player2) {
        if (!TradeLogService.connected()) {
            return false;
        }
        return TradeLogService.getTradeLogRepository().haveTraded(player1, player2);
    }

    public static void haveTraded(@NotNull String player1, @NotNull String player2, @NotNull Callback<Boolean> callback) {
        if (!TradeLogService.connected()) {
            callback.accept(false);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TradeSystem.getInstance(), () -> callback.accept(TradeLogService.getTradeLogRepository().haveTraded(player1, player2)));
    }

    public static boolean connected() {
        return TradeSystem.getInstance().getDatabaseInitializer().isRunning();
    }

    @NotNull
    private static TradeLogRepository getTradeLogRepository() {
        DatabaseType type = TradeSystem.database().getType();
        switch (type) {
            case MYSQL: {
                return new MysqlTradeLogRepository();
            }
            case SQLITE: {
                return new SqlLiteTradeLogRepository();
            }
        }
        throw new RuntimeException("Invalid database type provided: " + (Object)((Object)type));
    }
}

