/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.tradelog;

import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.events.TradeLogReceiveItemEvent;
import de.codingair.tradesystem.spigot.extras.external.PluginDependencies;
import de.codingair.tradesystem.spigot.extras.external.mmoitems.MMOItemsDependency;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.MissingFormatArgumentException;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class TradeLog {
    public static final Message STARTED = new Message("started", "Trade started", "\u00a7e");
    public static final Message CANCELLED_WITH_REASON = new Message("cancelled", "Trade cancelled: %s", "\u00a7c");
    public static final Message CANCELLED = new Message("cancelled", "Trade cancelled", "\u00a7c");
    public static final Message FINISHED = new Message("finished", "Trade finished", "\u00a7a");
    public static final Message OFFERED_AMOUNT = new Message("offered", "%s offered %s: %s", "\u00a78");
    public static final Message RECEIVED = new Message("received", "%s received %s", "\u00a78");
    public static final Message RECEIVED_AMOUNT = new Message("received", "%s received %s: %s", "\u00a78");
    public static final Set<Message> MESSAGES = new HashSet<Message>();

    public static void logItemReceive(@NotNull Player receiver, boolean initiator, @NotNull String trader, @NotNull UUID tradeId, @NotNull ItemStack getting) {
        Player tradingPlayer = Bukkit.getPlayerExact((String)trader);
        TradeLogReceiveItemEvent e = tradingPlayer == null ? new TradeLogReceiveItemEvent(receiver, trader, tradeId, getting) : new TradeLogReceiveItemEvent(receiver, tradingPlayer, getting);
        Bukkit.getPluginManager().callEvent((Event)e);
        String message = e.getMessage();
        if (message == null) {
            String type = PluginDependencies.get(MMOItemsDependency.class).getMmoNameSafely(getting);
            if (type == null) {
                type = getting.getType().name();
            }
            if (getting.hasItemMeta() && getting.getItemMeta().hasDisplayName()) {
                type = type + " (" + ChatColor.stripColor(getting.getItemMeta().getDisplayName()) + ")";
            }
            message = getting.getAmount() + "x " + type;
        }
        TradeLogService.log(initiator ? receiver.getName() : trader, initiator ? trader : receiver.getName(), RECEIVED.get(receiver.getName(), message));
    }

    @NotNull
    public static String getColorByString(@NotNull String s) {
        s = s.toLowerCase();
        for (Message m : MESSAGES) {
            if (!s.contains(m.searchTag)) continue;
            return m.color;
        }
        return "\u00a78";
    }

    static {
        MESSAGES.add(STARTED);
        MESSAGES.add(CANCELLED_WITH_REASON);
        MESSAGES.add(CANCELLED);
        MESSAGES.add(FINISHED);
        MESSAGES.add(RECEIVED);
        MESSAGES.add(RECEIVED_AMOUNT);
    }

    public static class Message {
        private final String searchTag;
        private final String message;
        private final String color;

        public Message(@NotNull String searchTag, @NotNull String message, @NotNull String color) {
            this.searchTag = searchTag.toLowerCase();
            this.message = message;
            this.color = color;
        }

        @NotNull
        public String get(Object ... replacements) {
            try {
                return String.format(this.message, replacements);
            }
            catch (MissingFormatArgumentException e) {
                throw new IllegalStateException("The number of placeholders in the message '" + this.message + "' does not match the number of replacements which are: " + Arrays.toString(replacements), e);
            }
        }
    }

    public static class Entry {
        private final String player1Name;
        private final String player2Name;
        private final String message;
        private final LocalDateTime timestamp;

        public Entry(String player1Name, String player2Name, String message, LocalDateTime timestamp) {
            this.player1Name = player1Name;
            this.player2Name = player2Name;
            this.message = message;
            this.timestamp = timestamp;
        }

        public String getPlayer1Name() {
            return this.player1Name;
        }

        public String getPlayer2Name() {
            return this.player2Name;
        }

        public String getMessage() {
            return this.message;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }
    }
}

