/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.worldguard;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeRequestEvent;
import de.codingair.tradesystem.spigot.events.TradeRequestPreResponseEvent;
import de.codingair.tradesystem.spigot.extras.external.PluginDependency;
import de.codingair.tradesystem.spigot.extras.external.worldguard.WorldGuardAdapter;
import de.codingair.tradesystem.spigot.extras.external.worldguard.WorldGuardAdapter_12;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public class WorldGuardDependency
implements PluginDependency,
Listener {
    private WorldGuardAdapter adapter;
    private Set<String> regions;
    private RegionMode mode;

    @Override
    public void onEnable() {
        this.prepareAdapter();
        if (!this.loadRegions()) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void onPreResponse(TradeRequestPreResponseEvent e) {
        if (e.isAccepted()) {
            if (e.getReceivingPlayer() != null && this.invalidRegion(e.getReceivingPlayer())) {
                Lang.send((CommandSender)e.getReceivingPlayer(), "", "Cannot_trade_in_region", ($, s) -> e.sendMessage(e.getReceivingPlayer(), e.getReceiver(), (String)s), new Lang.P[0]);
                e.setCancelled(true);
                return;
            }
            if (e.getSendingPlayer() != null && this.invalidRegion(e.getSendingPlayer())) {
                Lang.send((CommandSender)e.getReceivingPlayer(), "", "Other_cannot_trade_in_region", ($, s) -> e.sendMessage(e.getReceivingPlayer(), e.getReceiver(), (String)s), new Lang.P[0]);
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onRequest(TradeRequestEvent e) {
        if (e.getSendingPlayer() != null && this.invalidRegion(e.getSendingPlayer())) {
            Lang.send((CommandSender)e.getSendingPlayer(), "", "Cannot_trade_in_region", ($, s) -> e.sendMessage(e.getSendingPlayer(), e.getSender(), (String)s), new Lang.P[0]);
            e.setCancelled(true);
            return;
        }
        if (e.getReceivingPlayer() != null && this.invalidRegion(e.getReceivingPlayer())) {
            Lang.send((CommandSender)e.getSendingPlayer(), "", "Other_cannot_trade_in_region", ($, s) -> e.sendMessage(e.getSendingPlayer(), e.getSender(), (String)s), new Lang.P[0]);
            e.setCancelled(true);
        }
    }

    private boolean invalidRegion(@NotNull Player player) {
        if (this.mode == RegionMode.BLACKLIST) {
            return !this.allowedInBlackList(player);
        }
        return !this.checkWhiteList(player);
    }

    private boolean allowedInBlackList(@NotNull Player player) {
        return this.getRegions(player.getLocation()).noneMatch(this.regions::contains);
    }

    private boolean checkWhiteList(@NotNull Player player) {
        return this.getRegions(player.getLocation()).anyMatch(this.regions::contains);
    }

    @NotNull
    private Stream<String> getRegions(@NotNull Location location) {
        try {
            return this.adapter.getRegion(location);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }

    private void prepareAdapter() {
        try {
            WorldGuardAdapter.test();
            this.adapter = new WorldGuardAdapter();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            try {
                WorldGuardAdapter_12.test();
                this.adapter = new WorldGuardAdapter_12();
            }
            catch (ClassNotFoundException | NoClassDefFoundError e1) {
                TradeSystem.getInstance().getLogger().log(Level.WARNING, "Could not hook into WorldGuard. Please contact the author!");
            }
        }
    }

    private boolean loadRegions() {
        YamlConfiguration config = TradeSystem.getInstance().getFileManager().getFile("Config").getConfig();
        ConfigurationSection configRegions = config.getConfigurationSection("TradeSystem.Allowed_Regions");
        if (configRegions == null) {
            return false;
        }
        String modeName = configRegions.getString("Mode");
        this.mode = RegionMode.byName(modeName);
        if (this.mode == null) {
            TradeSystem.getInstance().getLogger().log(Level.WARNING, String.format("Invalid region mode '%s'. Using BLACKLIST.", new Object[]{this.mode}));
            this.mode = RegionMode.BLACKLIST;
        }
        this.regions = new HashSet<String>(configRegions.getStringList("Regions"));
        return true;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "WorldGuard";
    }

    private static enum RegionMode {
        BLACKLIST,
        WHITELIST;


        @Nullable
        public static RegionMode byName(@Nullable String name) {
            for (RegionMode value : RegionMode.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }
}

