/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.vault;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.extras.external.EconomySupportType;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import de.codingair.tradesystem.spigot.extras.external.vault.ShowVaultIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import java.math.BigDecimal;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultIcon
extends EconomyIcon<ShowVaultIcon> {
    public VaultIcon(@NotNull ItemStack itemStack) {
        super(itemStack, "Coin", "Coins", true);
    }

    @Override
    public Class<ShowVaultIcon> getTargetClass() {
        return ShowVaultIcon.class;
    }

    @Override
    @NotNull
    protected BigDecimal getBalance(@NotNull Player player) {
        return BigDecimal.valueOf(this.getEconomy().getBalance((OfflinePlayer)player));
    }

    @Override
    protected void withdraw(Player player, @NotNull BigDecimal value) {
        this.getEconomy().withdrawPlayer((OfflinePlayer)player, value.doubleValue());
    }

    @Override
    protected void deposit(Player player, @NotNull BigDecimal value) {
        this.getEconomy().depositPlayer((OfflinePlayer)player, value.doubleValue());
    }

    @Override
    @NotNull
    protected TypeCap getMaxSupportedValue() {
        return EconomySupportType.DOUBLE;
    }

    private Economy getEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            return (Economy)economyProvider.getProvider();
        }
        throw new IllegalStateException("Vault is not enabled properly.");
    }
}

