/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.tokenmanager;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.extras.external.EconomySupportType;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import de.codingair.tradesystem.spigot.extras.external.tokenmanager.ShowTokenIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import java.math.BigDecimal;
import me.realized.tokenmanager.api.TokenManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TokenIcon
extends EconomyIcon<ShowTokenIcon> {
    public TokenIcon(@NotNull ItemStack itemStack) {
        super(itemStack, "Token", "Tokens", false);
    }

    @Override
    public Class<ShowTokenIcon> getTargetClass() {
        return ShowTokenIcon.class;
    }

    @NotNull
    private TokenManager getTokenManager() {
        TokenManager tokenManager = (TokenManager)Bukkit.getPluginManager().getPlugin("TokenManager");
        assert (tokenManager != null);
        return tokenManager;
    }

    @Override
    @NotNull
    protected BigDecimal getBalance(@NotNull Player player) {
        return BigDecimal.valueOf(this.getTokenManager().getTokens(player).orElse(0L));
    }

    @Override
    protected void withdraw(Player player, @NotNull BigDecimal value) {
        this.getTokenManager().removeTokens(player, value.longValue());
    }

    @Override
    protected void deposit(Player player, @NotNull BigDecimal value) {
        this.getTokenManager().addTokens(player, value.longValue());
    }

    @Override
    @NotNull
    protected TypeCap getMaxSupportedValue() {
        return EconomySupportType.LONG;
    }
}

