/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.playerpoints;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.extras.external.EconomySupportType;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import de.codingair.tradesystem.spigot.extras.external.playerpoints.ShowPlayerPointsIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import java.math.BigDecimal;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerPointsIcon
extends EconomyIcon<ShowPlayerPointsIcon> {
    public PlayerPointsIcon(@NotNull ItemStack itemStack) {
        super(itemStack, "PlayerPoint", "PlayerPoints", false);
    }

    @Override
    public Class<ShowPlayerPointsIcon> getTargetClass() {
        return ShowPlayerPointsIcon.class;
    }

    private PlayerPointsAPI api() {
        return PlayerPoints.getInstance().getAPI();
    }

    @Override
    @NotNull
    protected BigDecimal getBalance(@NotNull Player player) {
        return BigDecimal.valueOf(this.api().look(player.getUniqueId()));
    }

    @Override
    protected void withdraw(Player player, @NotNull BigDecimal value) {
        this.api().take(player.getUniqueId(), value.intValue());
    }

    @Override
    protected void deposit(Player player, @NotNull BigDecimal value) {
        this.api().give(player.getUniqueId(), value.intValue());
    }

    @Override
    @NotNull
    protected TypeCap getMaxSupportedValue() {
        return EconomySupportType.INTEGER;
    }
}

