/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.placeholderapi;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeFinishEvent;
import de.codingair.tradesystem.spigot.extras.external.PluginDependency;
import de.codingair.tradesystem.spigot.extras.external.placeholderapi.TradeSystemPlaceholder;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogService;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlaceholderDependency
implements PluginDependency,
Listener {
    private static PlaceholderDependency instance;
    static final String IDENTIFIER = "tradesystem";
    static final Pattern PATTERN;
    private TradeSystemPlaceholder placeholder;
    private static final Map<UUID, Long> successfulTrades;

    public PlaceholderDependency() {
        instance = this;
    }

    @EventHandler
    public void onTradeFinish(TradeFinishEvent e) {
        if (e.getTradeResult() && TradeLogService.connected()) {
            if (e.getSendingPlayer() != null) {
                this.increaseSuccessfulTrades(e.getSenderId());
            }
            if (e.getReceivingPlayer() != null) {
                this.increaseSuccessfulTrades(e.getReceiverId());
            }
        }
    }

    @EventHandler
    public void onLogin(AsyncPlayerPreLoginEvent e) {
        long trades = TradeLogService.count(e.getName(), TradeLog.FINISHED.get(new Object[0]));
        if (trades > 0L) {
            successfulTrades.put(e.getUniqueId(), trades);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        successfulTrades.remove(e.getPlayer().getUniqueId());
    }

    private void increaseSuccessfulTrades(@NotNull UUID senderId) {
        long trades = successfulTrades.getOrDefault(senderId, 0L);
        successfulTrades.put(senderId, trades + 1L);
    }

    @NotNull
    public static String convert(@NotNull String s, @NotNull Player player) {
        if (instance.isAvailable()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)s);
        }
        Matcher m = PATTERN.matcher(s);
        while (m.find()) {
            String group = m.group();
            String id = group.substring(1 + IDENTIFIER.length() + 1, group.length() - 1);
            String replacement = PlaceholderDependency.apply(player, id);
            if (replacement == null) continue;
            s = s.substring(0, m.start()) + replacement + s.substring(m.end());
        }
        return s;
    }

    @Override
    public void onEnable() {
        this.placeholder = new TradeSystemPlaceholder();
        this.placeholder.register();
    }

    @Override
    public void onDisable() {
        if (this.placeholder != null) {
            this.placeholder.unregister();
        }
    }

    @Nullable
    static String apply(@NotNull Player player, @NotNull String id) {
        Trade t = TradeSystem.handler().getTrade(player);
        switch (id.toLowerCase()) {
            case "partner": 
            case "trade_partner": {
                if (t != null) {
                    return t.getOther(player.getName());
                }
                return "";
            }
            case "countdown": {
                if (t != null && t.getCountdown() != null) {
                    int remaining = (int)Math.ceil((float)(TradeSystem.handler().getCountdownInterval() * (TradeSystem.handler().getCountdownRepetitions() - t.getCountdownTicks())) / 20.0f);
                    return String.valueOf(remaining);
                }
                return "";
            }
            case "countdown_fancy": {
                if (t != null && t.getCountdown() != null) {
                    int remaining = (int)Math.ceil((float)(TradeSystem.handler().getCountdownInterval() * (TradeSystem.handler().getCountdownRepetitions() - t.getCountdownTicks())) / 20.0f);
                    return Lang.get("Fancy_Countdown", new Lang.P[0]).replace("%seconds%", remaining + "");
                }
                return "";
            }
            case "status": {
                if (TradeSystem.handler().isOffline(player)) {
                    return Lang.get("Offline", new Lang.P[0]);
                }
                return Lang.get("Online", new Lang.P[0]);
            }
            case "is_trading": {
                return t != null ? "true" : "false";
            }
            case "num_trades": {
                return String.valueOf(successfulTrades.getOrDefault(player.getUniqueId(), 0L));
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "PlaceholderAPI";
    }

    static {
        PATTERN = Pattern.compile("%tradesystem_[a-z_]+%", 2);
        successfulTrades = new HashMap<UUID, Long>();
    }
}

