/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.mmoitems;

import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeLogReceiveItemEvent;
import de.codingair.tradesystem.spigot.events.TradeReportEvent;
import de.codingair.tradesystem.spigot.extras.external.PluginDependency;
import de.codingair.tradesystem.spigot.trade.PlayerTradeResult;
import net.Indyuce.mmoitems.MMOItems;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MMOItemsDependency
implements PluginDependency,
Listener {
    @EventHandler
    public void onTradeLog(TradeLogReceiveItemEvent e) {
        String display = this.getMmoFormat(e.getItem());
        if (display != null) {
            e.setMessage(display);
        }
    }

    @EventHandler
    public void onReport(TradeReportEvent e) {
        e.setItemReport(e.getResult().buildItemReport(item -> {
            String type = this.getMmoId((ItemStack)item);
            if (type == null || type.isEmpty()) {
                type = item.getType().name();
            }
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                assert (meta != null);
                if (meta.hasDisplayName()) {
                    return TradeSystem.handler().isOnlyDisplayNameInMessage() ? meta.getDisplayName() : PlayerTradeResult.formatName(type) + " (" + ChatColor.stripColor(meta.getDisplayName()) + ")";
                }
            }
            return PlayerTradeResult.formatName(type);
        }));
    }

    @Nullable
    private String getMmoFormat(@NotNull ItemStack item) {
        String type = this.getMmoType(item);
        String id = this.getMmoId(item);
        if (type == null || id == null) {
            return null;
        }
        String displayName = null;
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            if (meta.hasDisplayName()) {
                displayName = ChatColor.stripColor(meta.getDisplayName()) + " ";
            }
        }
        if (displayName != null) {
            return item.getAmount() + "x " + displayName + " (MMOItem." + type + "." + id + ")";
        }
        return item.getAmount() + "x MMOItem (" + type + "." + id + ")";
    }

    @Nullable
    private String getMmoType(@NotNull ItemStack item) {
        return MMOItems.getTypeName((ItemStack)item);
    }

    @Nullable
    private String getMmoId(@NotNull ItemStack item) {
        return MMOItems.getID((ItemStack)item);
    }

    @Nullable
    public String getMmoNameSafely(@NotNull ItemStack item) {
        if (!this.isAvailable()) {
            return null;
        }
        return this.getMmoType(item);
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "MMOItems";
    }
}

