/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.extras.external.EconomySupportType;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import de.codingair.tradesystem.spigot.extras.external.essentials.ShowEssentialsIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import net.ess3.api.MaxMoneyException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EssentialsIcon
extends EconomyIcon<ShowEssentialsIcon> {
    public EssentialsIcon(@NotNull ItemStack itemStack) {
        super(itemStack, "Coin", "Coins", true);
    }

    @Override
    public Class<ShowEssentialsIcon> getTargetClass() {
        return ShowEssentialsIcon.class;
    }

    @Override
    @NotNull
    protected BigDecimal getBalance(@NotNull Player player) {
        this.check(player);
        try {
            return Economy.getMoneyExact((UUID)player.getUniqueId());
        }
        catch (UserDoesNotExistException e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    @Override
    protected void withdraw(Player player, @NotNull BigDecimal value) {
        this.check(player);
        try {
            Economy.subtract((UUID)player.getUniqueId(), (BigDecimal)value);
        }
        catch (NoLoanPermittedException | UserDoesNotExistException | MaxMoneyException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void deposit(Player player, @NotNull BigDecimal value) {
        this.check(player);
        try {
            Economy.add((UUID)player.getUniqueId(), (BigDecimal)value);
        }
        catch (NoLoanPermittedException | UserDoesNotExistException | MaxMoneyException e) {
            e.printStackTrace();
        }
    }

    private void check(Player player) {
        if (!Economy.playerExists((UUID)player.getUniqueId())) {
            Economy.createNPC((String)player.getName());
        }
    }

    @Override
    @NotNull
    protected Optional<BigDecimal> getBalanceLimit(@NotNull Player player) {
        Essentials ess = (Essentials)Essentials.getProvidingPlugin(Essentials.class);
        BigDecimal max = ess.getSettings().getMaxMoney();
        return max == null ? Optional.empty() : Optional.of(max.subtract(BigDecimal.ONE));
    }

    @Override
    @NotNull
    protected TypeCap getMaxSupportedValue() {
        return EconomySupportType.BIG_DECIMAL;
    }
}

