/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.math.BigDecimal;
import java.util.function.Function;

public class TypeCap {
    private final Class<? extends Number> type;
    private final Function<BigDecimal, BigDecimal> mapper;

    public TypeCap(@NotNull Class<? extends Number> type, @NotNull Function<BigDecimal, BigDecimal> mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    @NotNull
    public BigDecimal apply(@NotNull BigDecimal value) {
        return this.mapper.apply(value);
    }

    @NotNull
    public Class<? extends Number> getType() {
        return this.type;
    }

    public boolean isByte() {
        return this.type == Byte.class;
    }

    public boolean isShort() {
        return this.type == Short.class;
    }

    public boolean isInteger() {
        return this.type == Integer.class;
    }

    public boolean isLong() {
        return this.type == Long.class;
    }

    public boolean isNumber() {
        return this.isByte() || this.isShort() || this.isInteger() || this.isLong();
    }

    public boolean isFloat() {
        return this.type == Float.class;
    }

    public boolean isDouble() {
        return this.type == Double.class;
    }

    public boolean isDecimal() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isBigDecimal() {
        return this.type == BigDecimal.class;
    }
}

