/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.extras.external.PluginDependency;
import de.codingair.tradesystem.spigot.extras.external.essentials.EssentialsDependency;
import de.codingair.tradesystem.spigot.extras.external.griefdefender.GriefDefenderDependency;
import de.codingair.tradesystem.spigot.extras.external.mmoitems.MMOItemsDependency;
import de.codingair.tradesystem.spigot.extras.external.placeholderapi.PlaceholderDependency;
import de.codingair.tradesystem.spigot.extras.external.playerpoints.PlayerPointsDependency;
import de.codingair.tradesystem.spigot.extras.external.tokenmanager.TokenManagerDependency;
import de.codingair.tradesystem.spigot.extras.external.vault.VaultDependency;
import de.codingair.tradesystem.spigot.extras.external.worldguard.WorldGuardDependency;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class PluginDependencies {
    private static final PluginDependency[] EXTERNALS = new PluginDependency[]{new PlaceholderDependency(), new EssentialsDependency(), new TokenManagerDependency(), new VaultDependency(), new PlayerPointsDependency(), new GriefDefenderDependency(), new MMOItemsDependency(), new WorldGuardDependency()};

    public static boolean isEnabled(@NotNull Class<? extends PluginDependency> clazz) {
        for (PluginDependency dependency : EXTERNALS) {
            if (!dependency.getClass().equals(clazz)) continue;
            return dependency.isAvailable();
        }
        return false;
    }

    public static void enable() {
        for (PluginDependency external : EXTERNALS) {
            if (!external.isAvailable()) continue;
            if (external instanceof Listener) {
                Bukkit.getPluginManager().registerEvents((Listener)external, (Plugin)TradeSystem.getInstance());
            }
            external.onEnable();
        }
    }

    public static void disable() {
        for (PluginDependency external : EXTERNALS) {
            if (!external.isAvailable()) continue;
            external.onDisable();
            if (!(external instanceof Listener)) continue;
            HandlerList.unregisterAll((Listener)((Listener)external));
        }
    }

    @NotNull
    public static <T extends PluginDependency> T get(@NotNull Class<T> c) {
        for (PluginDependency external : EXTERNALS) {
            if (!c.isInstance(external)) continue;
            return (T)external;
        }
        throw new IllegalArgumentException("Unknown dependency: " + c.getName());
    }
}

