/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.external;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class EconomySupportType {
    private static final BigDecimal MAX_BYTE = BigDecimal.valueOf(127L);
    private static final BigDecimal MIN_BYTE = BigDecimal.valueOf(-128L);
    private static final BigDecimal MAX_SHORT = BigDecimal.valueOf(32767L);
    private static final BigDecimal MIN_SHORT = BigDecimal.valueOf(-32768L);
    private static final BigDecimal MAX_INTEGER = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MIN_INTEGER = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    private static final BigDecimal MIN_FLOAT = BigDecimal.valueOf(1.4E-45f);
    private static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal MIN_DOUBLE = BigDecimal.valueOf(Double.MIN_VALUE);
    public static final TypeCap BYTE = new TypeCap(Byte.class, d -> d.min(MAX_BYTE).max(MIN_BYTE).setScale(0, RoundingMode.DOWN));
    public static final TypeCap SHORT = new TypeCap(Short.class, d -> d.min(MAX_SHORT).max(MIN_SHORT).setScale(0, RoundingMode.DOWN));
    public static final TypeCap INTEGER = new TypeCap(Integer.class, d -> d.min(MAX_INTEGER).max(MIN_INTEGER).setScale(0, RoundingMode.DOWN));
    public static final TypeCap LONG = new TypeCap(Long.class, d -> d.min(MAX_LONG).max(MIN_LONG).setScale(0, RoundingMode.DOWN));
    public static final TypeCap FLOAT = new TypeCap(Float.class, EconomySupportType::toFloat);
    public static final TypeCap DOUBLE = new TypeCap(Double.class, EconomySupportType::toDouble);
    public static final TypeCap BIG_DECIMAL = new TypeCap(BigDecimal.class, d -> d);

    private EconomySupportType() {
    }

    @NotNull
    private static BigDecimal toFloat(@NotNull BigDecimal value) {
        if (Double.isInfinite(value.floatValue())) {
            return value.floatValue() < 0.0f ? MIN_FLOAT : MAX_FLOAT;
        }
        return BigDecimal.valueOf(value.floatValue());
    }

    @NotNull
    private static BigDecimal toDouble(@NotNull BigDecimal value) {
        if (Double.isInfinite(value.doubleValue())) {
            return value.doubleValue() < 0.0 ? MIN_DOUBLE : MAX_DOUBLE;
        }
        return BigDecimal.valueOf(value.doubleValue());
    }
}

