/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.extras.blacklist;

import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.DataMask;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.utils.ShulkerBoxHelper;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BlockedItem
implements Serializable {
    @Nullable
    public Material material;
    @Nullable
    public Byte data;
    @Nullable
    public String originalDisplayName;
    @Nullable
    public String displayName;
    @Nullable
    public String originalLore;
    @Nullable
    public String lore;
    @Nullable
    public Integer customModelData;
    @NotNull
    public StringCompare compare = StringCompare.IGNORE_CASE;

    private BlockedItem() {
    }

    @NotNull
    public static BlockedItem create() {
        return new BlockedItem();
    }

    @NotNull
    public static BlockedItem create(@NotNull Map<?, ?> yml) {
        JSON data = new JSON(yml);
        BlockedItem item = BlockedItem.create();
        item.read(data);
        return item;
    }

    @Deprecated
    public static BlockedItem fromString(String s) {
        try {
            JSONObject json = (JSONObject)new JSONParser().parse(s);
            Material material = json.get((Object)"Material") == null ? null : Material.valueOf((String)((String)json.get((Object)"Material")));
            Byte data = json.get((Object)"Data") == null ? null : Byte.valueOf(Byte.parseByte(json.get((Object)"Data") + ""));
            String name = json.get((Object)"Displayname") == null ? null : (String)json.get((Object)"Displayname");
            return BlockedItem.create().material(material).data(data).displayName(name);
        }
        catch (IllegalArgumentException | NoSuchFieldError ex) {
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean read(DataMask mask) {
        StringCompare regex;
        this.material = mask.get("Material", Material.class);
        this.data = mask.getByte("Data");
        if (this.data == 0) {
            this.data = null;
        }
        this.displayName = mask.getString("DisplayName");
        if (this.displayName != null) {
            this.originalDisplayName = this.displayName;
            this.displayName = ChatColor.translateAll('&', this.displayName);
        }
        this.lore = mask.getString("Lore");
        if (this.lore != null) {
            this.originalLore = this.lore;
            this.lore = ChatColor.translateAll('&', this.lore);
        }
        this.compare = (regex = mask.get("Compare", StringCompare.class)) == null ? StringCompare.IGNORE_CASE : regex;
        this.customModelData = mask.getInteger("CustomModelData", null);
        return true;
    }

    @Override
    public void write(DataMask mask) {
        mask.put("Material", this.material);
        mask.put("Data", this.data);
        mask.put("DisplayName", this.originalDisplayName);
        mask.put("Lore", this.originalLore);
        mask.put("Compare", (Object)this.compare);
        mask.put("CustomModelData", this.customModelData);
    }

    public boolean matches(@NotNull ItemStack item) {
        if (this.notValid()) {
            return false;
        }
        if (this.matchShulkerBoxContent(item)) {
            return true;
        }
        if (this.missMaterial(item)) {
            return false;
        }
        if (this.missDisplayName(item)) {
            return false;
        }
        if (this.missLore(item)) {
            return false;
        }
        return !this.missCustomModelData(item);
    }

    private boolean notValid() {
        return this.material == null && this.displayName == null && this.lore == null && this.customModelData == null;
    }

    private boolean matchShulkerBoxContent(@NotNull ItemStack item) {
        if (Version.atLeast(11.0)) {
            for (ItemStack itemStack : ShulkerBoxHelper.getItems(item)) {
                if (itemStack == null || !this.matches(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean missMaterial(@NotNull ItemStack item) {
        if (this.material == null) {
            return false;
        }
        if (Version.get().isBiggerThan(Version.v1_12) || this.data == null) {
            return item.getType() != this.material;
        }
        return item.getType() != this.material || item.getData() == null || this.data.byteValue() != item.getData().getData();
    }

    private boolean missDisplayName(@NotNull ItemStack item) {
        if (this.displayName == null) {
            return false;
        }
        if (item.hasItemMeta() && item.getItemMeta() != null) {
            String displayName = item.getItemMeta().getDisplayName();
            return !this.compare.check(displayName, this.displayName);
        }
        return true;
    }

    private boolean missLore(@NotNull ItemStack item) {
        ItemMeta meta;
        if (this.lore == null) {
            return false;
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()) != null && meta.getLore() != null) {
            return meta.getLore().stream().noneMatch(s -> this.compare.check((String)s, this.lore));
        }
        return true;
    }

    private boolean missCustomModelData(@NotNull ItemStack item) {
        if (this.customModelData == null || Version.less(14.0)) {
            return false;
        }
        if (item.hasItemMeta() && item.getItemMeta() != null) {
            return this.customModelData.intValue() != item.getItemMeta().getCustomModelData();
        }
        return true;
    }

    @Nullable
    public Material getMaterial() {
        return this.material;
    }

    @NotNull
    public BlockedItem material(@Nullable Material material) {
        this.material = material;
        return this;
    }

    @Nullable
    public Byte getData() {
        return this.data;
    }

    @NotNull
    public BlockedItem data(@Nullable Byte data) {
        this.data = data;
        return this;
    }

    @Nullable
    public String getDisplayName() {
        return this.originalDisplayName;
    }

    @NotNull
    public BlockedItem displayName(@Nullable String displayName) {
        this.originalDisplayName = displayName;
        this.displayName = displayName != null ? ChatColor.translateAll('&', displayName) : null;
        return this;
    }

    @Nullable
    public String getLore() {
        return this.originalLore;
    }

    @NotNull
    public BlockedItem lore(@Nullable String lore) {
        this.originalLore = lore;
        this.lore = lore != null ? ChatColor.translateAll('&', lore) : null;
        return this;
    }

    @NotNull
    public BlockedItem strict() {
        this.compare = StringCompare.STRICT;
        return this;
    }

    @NotNull
    public BlockedItem ignoreCase() {
        this.compare = StringCompare.IGNORE_CASE;
        return this;
    }

    @NotNull
    public BlockedItem contains() {
        this.compare = StringCompare.CONTAINS;
        return this;
    }

    @NotNull
    public BlockedItem containsIgnoreCase() {
        this.compare = StringCompare.CONTAINS_IGNORE_CASE;
        return this;
    }

    @NotNull
    public BlockedItem regexAny() {
        this.compare = StringCompare.REGEX_ANY;
        return this;
    }

    @NotNull
    public BlockedItem regexAll() {
        this.compare = StringCompare.REGEX_ALL;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockedItem)) {
            return false;
        }
        BlockedItem that = (BlockedItem)o;
        return this.getMaterial() == that.getMaterial() && Objects.equals(this.getData(), that.getData()) && Objects.equals(this.originalDisplayName, that.originalDisplayName) && Objects.equals(this.originalLore, that.originalLore) && this.compare == that.compare && Objects.equals(this.customModelData, that.customModelData);
    }

    public int hashCode() {
        String material = this.getMaterial() == null ? null : this.getMaterial().name();
        return Objects.hash(material, this.getData(), this.originalDisplayName, this.originalLore, this.compare.ordinal(), this.customModelData);
    }

    public String toString() {
        return "BlockedItem{material=" + this.material + ", data=" + this.data + ", displayName='" + this.originalDisplayName + '\'' + ", lore='" + this.originalLore + '\'' + ", regex=" + (Object)((Object)this.compare) + ", customModelData=" + this.customModelData + '}';
    }

    public static enum StringCompare {
        STRICT(String::equals),
        CONTAINS(String::contains),
        CONTAINS_IGNORE_CASE((s0, s1) -> s0.toLowerCase().contains(s1.toLowerCase())),
        IGNORE_CASE(String::equalsIgnoreCase),
        REGEX_ANY((s, regex) -> {
            Matcher m = Pattern.compile(regex).matcher((CharSequence)s);
            return m.find();
        }),
        REGEX_ALL((s, regex) -> {
            Matcher m = Pattern.compile(regex).matcher((CharSequence)s);
            return m.matches();
        });

        private final BiFunction<String, String, Boolean> compare;

        private StringCompare(BiFunction<String, String, Boolean> compare) {
            this.compare = compare;
        }

        public boolean check(@Nullable String s, @NotNull String with) {
            if (s == null) {
                return false;
            }
            return this.compare.apply(s, with);
        }
    }
}

