/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.ext;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.utils.Lang;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public abstract class Extension {
    private final String name;
    private final String description;
    private final String downloadLink;

    public Extension(@NotNull String name, @Nullable String description, @Nullable String downloadLink) {
        this.name = name;
        this.description = description;
        this.downloadLink = downloadLink;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled(this.getName());
    }

    @Nullable
    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin(this.name);
    }

    @Nullable
    public String getCurrentVersion() {
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            return null;
        }
        return plugin.getDescription().getVersion();
    }

    public void sendDownloadInfo(@NotNull CommandSender sender) {
        TextComponent tc = new TextComponent(TextComponent.fromLegacyText((String)(Lang.getPrefix() + "This function is only available with "), (ChatColor)ChatColor.GRAY));
        TextComponent link = new TextComponent(this.name);
        link.setColor(ChatColor.of((String)"#69e070"));
        if (this.downloadLink != null) {
            link.setItalic(Boolean.valueOf(true));
            link.setUnderlined(Boolean.valueOf(true));
            link.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadLink));
        }
        tc.addExtra((BaseComponent)link);
        if (this.description != null) {
            tc.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)("\u00a77: " + this.description), (ChatColor)ChatColor.GRAY)));
        } else {
            tc.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)"\u00a77.", (ChatColor)ChatColor.GRAY)));
        }
        sender.spigot().sendMessage((BaseComponent)tc);
    }

    @Nullable
    public String getDownloadLink() {
        return this.downloadLink;
    }
}

