/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;

public class TradeRequestEvent
extends TradeEvent
implements Cancellable {
    private static final HandlerList handlerList = new HandlerList();
    private final String sender;
    private final UUID senderId;
    private final Player sendingPlayer;
    private final String receiver;
    private final UUID receiverId;
    private final Player receivingPlayer;
    private final int expiresIn;
    private boolean cancelled = false;

    public TradeRequestEvent(@NotNull String sender, @NotNull UUID senderId, @NotNull Player receiver, int expiresIn) {
        this.sender = sender;
        this.senderId = senderId;
        this.sendingPlayer = null;
        this.receiver = receiver.getName();
        this.receiverId = receiver.getUniqueId();
        this.receivingPlayer = receiver;
        this.expiresIn = expiresIn;
    }

    public TradeRequestEvent(@NotNull Player sender, @NotNull String receiver, @NotNull UUID receiverId, int expiresIn) {
        this.sender = sender.getName();
        this.senderId = sender.getUniqueId();
        this.sendingPlayer = sender;
        this.receiver = receiver;
        this.receiverId = receiverId;
        this.receivingPlayer = null;
        this.expiresIn = expiresIn;
    }

    public TradeRequestEvent(@NotNull Player sender, @NotNull Player receiver, int expiresIn) {
        this.sender = sender.getName();
        this.senderId = sender.getUniqueId();
        this.sendingPlayer = sender;
        this.receiver = receiver.getName();
        this.receiverId = receiver.getUniqueId();
        this.receivingPlayer = receiver;
        this.expiresIn = expiresIn;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeRequestEvent.getHandlerList();
    }

    @Nullable
    public Player getSendingPlayer() {
        return this.sendingPlayer;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @Nullable
    public Player getReceivingPlayer() {
        return this.receivingPlayer;
    }

    @NotNull
    public String getReceiver() {
        return this.receiver;
    }

    @NotNull
    public UUID getReceiverId() {
        return this.receiverId;
    }

    public boolean isProxyTrade() {
        return this.getSendingPlayer() == null || this.getReceivingPlayer() == null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }
}

