/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import de.codingair.tradesystem.spigot.trade.PlayerTradeResult;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;

public class TradeReportEvent
extends TradeEvent
implements Cancellable {
    private static final HandlerList handlerList = new HandlerList();
    private final Player receiver;
    private final String other;
    private final UUID otherId;
    private final Player otherPlayer;
    private final PlayerTradeResult result;
    private List<String> itemReport;
    private List<String> economyReport;
    private boolean playFinishSound = true;
    private boolean cancelled = false;

    public TradeReportEvent(@NotNull Player receiver, @NotNull String other, @NotNull UUID otherId, @NotNull PlayerTradeResult result) {
        this.receiver = receiver;
        this.other = other;
        this.otherId = otherId;
        this.result = result;
        this.otherPlayer = null;
    }

    public TradeReportEvent(@NotNull Player receiver, @NotNull Player otherPlayer, @NotNull PlayerTradeResult result) {
        this.receiver = receiver;
        this.otherPlayer = otherPlayer;
        this.otherId = otherPlayer.getUniqueId();
        this.result = result;
        this.other = otherPlayer.getName();
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeReportEvent.getHandlerList();
    }

    @NotNull
    public Player getReceiver() {
        return this.receiver;
    }

    @Nullable
    public Player getOtherPlayer() {
        return this.otherPlayer;
    }

    @NotNull
    public String getOther() {
        return this.other;
    }

    @NotNull
    public UUID getOtherId() {
        return this.otherId;
    }

    public boolean isProxyTrade() {
        return this.getOtherPlayer() == null;
    }

    @NotNull
    public PlayerTradeResult getResult() {
        return this.result;
    }

    @Nullable
    public List<String> getItemReport() {
        return this.itemReport;
    }

    public void setItemReport(@Nullable List<String> itemReport) {
        this.itemReport = itemReport;
    }

    @Nullable
    public List<String> getEconomyReport() {
        return this.economyReport;
    }

    public void setEconomyReport(@Nullable List<String> economyReport) {
        this.economyReport = economyReport;
    }

    public boolean isPlayFinishSound() {
        return this.playFinishSound;
    }

    public void setPlayFinishSound(boolean playFinishSound) {
        this.playFinishSound = playFinishSound;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

