/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import java.math.BigDecimal;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;

public class TradeReceiveEconomyEvent
extends TradeEvent {
    private static final HandlerList handlerList = new HandlerList();
    private final Player receiver;
    private final String sender;
    private final UUID senderId;
    private final Player sendingPlayer;
    private final BigDecimal balance;
    private final String nameSingular;
    private final String namePlural;

    public TradeReceiveEconomyEvent(@NotNull Player receiver, @NotNull String sender, @NotNull UUID senderId, @NotNull BigDecimal balance, @NotNull String nameSingular, @NotNull String namePlural) {
        this.receiver = receiver;
        this.sender = sender;
        this.senderId = senderId;
        this.sendingPlayer = null;
        this.balance = balance;
        this.nameSingular = nameSingular;
        this.namePlural = namePlural;
    }

    public TradeReceiveEconomyEvent(@NotNull Player receiver, @NotNull Player sendingPlayer, @NotNull BigDecimal balance, @NotNull String nameSingular, @NotNull String namePlural) {
        this.receiver = receiver;
        this.sender = sendingPlayer.getName();
        this.senderId = sendingPlayer.getUniqueId();
        this.sendingPlayer = sendingPlayer;
        this.balance = balance;
        this.nameSingular = nameSingular;
        this.namePlural = namePlural;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeReceiveEconomyEvent.getHandlerList();
    }

    @NotNull
    public Player getReceiver() {
        return this.receiver;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @Nullable
    public Player getSendingPlayer() {
        return this.sendingPlayer;
    }

    public boolean isProxyTrade() {
        return this.getSendingPlayer() == null;
    }

    @NotNull
    public BigDecimal getBalance() {
        return this.balance;
    }

    @NotNull
    public String getNameSingular() {
        return this.nameSingular;
    }

    @NotNull
    public String getNamePlural() {
        return this.namePlural;
    }
}

