/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class TradeOfferItemEvent
extends TradeEvent
implements Cancellable {
    private static final HandlerList handlerList = new HandlerList();
    private final Player player;
    private final String receiver;
    private final UUID receiverId;
    private final Player receivingPlayer;
    private final ItemStack itemStack;
    private boolean cancelled;

    public TradeOfferItemEvent(@NotNull Player player, @NotNull String receiver, @NotNull UUID receiverId, @NotNull ItemStack itemStack, boolean cancelled) {
        this.player = player;
        this.receiver = receiver;
        this.receiverId = receiverId;
        this.itemStack = itemStack;
        this.cancelled = cancelled;
        this.receivingPlayer = null;
    }

    public TradeOfferItemEvent(@NotNull Player player, @NotNull Player receivingPlayer, @NotNull ItemStack itemStack, boolean cancelled) {
        this.player = player;
        this.receivingPlayer = receivingPlayer;
        this.receiverId = receivingPlayer.getUniqueId();
        this.itemStack = itemStack;
        this.cancelled = cancelled;
        this.receiver = receivingPlayer.getName();
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeOfferItemEvent.getHandlerList();
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public String getReceiver() {
        return this.receiver;
    }

    @NotNull
    public UUID getReceiverId() {
        return this.receiverId;
    }

    @Nullable
    public Player getReceivingPlayer() {
        return this.receivingPlayer;
    }

    public boolean isProxyTrade() {
        return this.getReceivingPlayer() == null;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

