/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class TradeLogReceiveItemEvent
extends TradeEvent {
    private static final HandlerList handlerList = new HandlerList();
    private final Player receiver;
    private final String sender;
    private final UUID senderId;
    private final Player sendingPlayer;
    private final ItemStack item;
    private String message;

    public TradeLogReceiveItemEvent(@NotNull Player receiver, @NotNull String sender, @NotNull UUID senderId, @NotNull ItemStack item) {
        this.receiver = receiver;
        this.sender = sender;
        this.senderId = senderId;
        this.sendingPlayer = null;
        this.item = item;
    }

    public TradeLogReceiveItemEvent(@NotNull Player receiver, @NotNull Player sendingPlayer, @NotNull ItemStack item) {
        this.receiver = receiver;
        this.sender = sendingPlayer.getName();
        this.senderId = sendingPlayer.getUniqueId();
        this.sendingPlayer = sendingPlayer;
        this.item = item;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeLogReceiveItemEvent.getHandlerList();
    }

    @NotNull
    public Player getReceiver() {
        return this.receiver;
    }

    @Nullable
    public Player getSendingPlayer() {
        return this.sendingPlayer;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    public boolean isProxyTrade() {
        return this.getSendingPlayer() == null;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item.clone();
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }
}

