/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import de.codingair.tradesystem.spigot.trade.Trade;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class TradeItemEvent
extends TradeEvent {
    private static final HandlerList handlerList = new HandlerList();
    private final Player receiver;
    private final String sender;
    private final UUID senderId;
    private final Player sendingPlayer;
    private ItemStack item;

    public TradeItemEvent(@NotNull Player receiver, @NotNull String sender, @NotNull UUID senderId, @NotNull ItemStack item) {
        this.receiver = receiver;
        this.sender = sender;
        this.senderId = senderId;
        this.item = item;
        this.sendingPlayer = null;
    }

    public TradeItemEvent(@NotNull Player receiver, @NotNull Player sendingPlayer, @NotNull ItemStack item) {
        this.receiver = receiver;
        this.sender = sendingPlayer.getName();
        this.senderId = sendingPlayer.getUniqueId();
        this.sendingPlayer = sendingPlayer;
        this.item = item;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeItemEvent.getHandlerList();
    }

    @NotNull
    public Player getReceiver() {
        return this.receiver;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @Nullable
    public Player getSendingPlayer() {
        return this.sendingPlayer;
    }

    public boolean isProxyTrade() {
        return this.getSendingPlayer() == null;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(@Nullable ItemStack item) {
        this.item = item;
    }

    public boolean isAboutToDrop() {
        if (this.item == null) {
            return false;
        }
        return Trade.checkItemFit(this.receiver, this.item) > 0;
    }
}

