/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.EditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.TransitionTargetEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.TradeIconException;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.java.JavaPlugin;

public class TradeIconInitializeEvent
extends Event {
    private static final HandlerList handlerList = new HandlerList();
    private final BiConsumer<Class<? extends TradeIcon>, EditorInfo> registry;

    public TradeIconInitializeEvent(@NotNull BiConsumer<Class<? extends TradeIcon>, EditorInfo> registry) {
        this.registry = registry;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeIconInitializeEvent.getHandlerList();
    }

    public void registerIcon(@NotNull JavaPlugin plugin, @NotNull Class<? extends TradeIcon> icon, @NotNull EditorInfo info) throws TradeIconException {
        try {
            this.registry.accept(icon, info);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof TradeIconException) {
                throw new TradeIconException(this.getErrorMessage(plugin), ex.getCause());
            }
            throw new RuntimeException(this.getErrorMessage(plugin), ex.getCause());
        }
    }

    public void registerIcon(@NotNull JavaPlugin plugin, @NotNull Class<? extends TradeIcon> icon, @NotNull TransitionTargetEditorInfo info) throws TradeIconException {
        try {
            this.registry.accept(icon, info);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof TradeIconException) {
                throw new TradeIconException(this.getErrorMessage(plugin), ex.getCause());
            }
            throw new RuntimeException(this.getErrorMessage(plugin), ex.getCause());
        }
    }

    @NotNull
    private String getErrorMessage(@NotNull JavaPlugin plugin) {
        return "The plugin '" + plugin.getName() + "' by " + Arrays.toString(plugin.getDescription().getAuthors().toArray(new String[0])) + " issued an exception while registering TradeIcons for TradeSystem:";
    }
}

