/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.events;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.events.utils.TradeEvent;
import de.codingair.tradesystem.spigot.trade.TradeResult;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;

public class TradeFinishEvent
extends TradeEvent {
    private static final HandlerList handlerList = new HandlerList();
    private final String sender;
    private final UUID senderId;
    private final Player sendingPlayer;
    private final TradeResult sendingPlayerResult;
    private final String receiver;
    private final UUID receiverId;
    private final Player receivingPlayer;
    private final TradeResult receivingPlayerResult;
    private final boolean tradeResult;

    public TradeFinishEvent(@NotNull String sender, @NotNull UUID senderId, @NotNull Player receiver, boolean tradeResult, @NotNull @NotNull TradeResult @NotNull [] results) {
        this.sender = sender;
        this.senderId = senderId;
        this.sendingPlayer = null;
        this.receiver = receiver.getName();
        this.receivingPlayer = receiver;
        this.receiverId = receiver.getUniqueId();
        this.tradeResult = tradeResult;
        this.sendingPlayerResult = results[0];
        this.receivingPlayerResult = results[1];
    }

    public TradeFinishEvent(@NotNull Player sender, @NotNull String receiver, @NotNull UUID receiverId, boolean tradeResult, @NotNull @NotNull TradeResult @NotNull [] results) {
        this.sender = sender.getName();
        this.senderId = sender.getUniqueId();
        this.sendingPlayer = sender;
        this.receiver = receiver;
        this.receiverId = receiverId;
        this.receivingPlayer = null;
        this.tradeResult = tradeResult;
        this.sendingPlayerResult = results[0];
        this.receivingPlayerResult = results[1];
    }

    public TradeFinishEvent(@NotNull Player sender, @NotNull Player receiver, boolean tradeResult, @NotNull @NotNull TradeResult @NotNull [] results) {
        this.sender = sender.getName();
        this.senderId = sender.getUniqueId();
        this.sendingPlayer = sender;
        this.receiver = receiver.getName();
        this.receiverId = receiver.getUniqueId();
        this.receivingPlayer = receiver;
        this.tradeResult = tradeResult;
        this.sendingPlayerResult = results[0];
        this.receivingPlayerResult = results[1];
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return TradeFinishEvent.getHandlerList();
    }

    @Nullable
    public Player getSendingPlayer() {
        return this.sendingPlayer;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @Nullable
    public Player getReceivingPlayer() {
        return this.receivingPlayer;
    }

    @NotNull
    public String getReceiver() {
        return this.receiver;
    }

    @NotNull
    public UUID getReceiverId() {
        return this.receiverId;
    }

    public boolean isProxyTrade() {
        return this.getSendingPlayer() == null || this.getReceivingPlayer() == null;
    }

    public boolean getTradeResult() {
        return this.tradeResult;
    }

    @NotNull
    public TradeResult getSendingPlayerResult() {
        return this.sendingPlayerResult;
    }

    @NotNull
    public TradeResult getReceivingPlayerResult() {
        return this.receivingPlayerResult;
    }
}

