/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.database.migrations.sqlite;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.database.migrations.SqlMigrations;
import de.codingair.tradesystem.spigot.database.migrations.sqlite.AddIndexTradeLogTableMigration;
import de.codingair.tradesystem.spigot.database.migrations.sqlite.CreatePlayerNameTableMigration;
import de.codingair.tradesystem.spigot.database.migrations.sqlite.CreateTradeLogTableMigration;
import de.codingair.tradesystem.spigot.database.migrations.sqlite.SqlLiteConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class SqLiteMigrations
extends SqlMigrations {
    private static SqLiteMigrations instance;

    private SqLiteMigrations() {
    }

    @Override
    @NotNull
    public Connection getConnection() throws Exception {
        return SqlLiteConnection.connect();
    }

    @Override
    public void setVersion(@NotNull Connection connection, @NotNull String user, int version) throws Exception {
        try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO migrations VALUES (?, ?) ON CONFLICT(user) DO UPDATE SET version=?;");){
            stmt.setString(1, user);
            stmt.setInt(2, version);
            stmt.setInt(3, version);
            stmt.executeUpdate();
        }
    }

    @NotNull
    public static SqLiteMigrations getInstance() {
        if (instance == null) {
            instance = new SqLiteMigrations();
        }
        return instance;
    }

    static {
        SqLiteMigrations.getInstance().register(TradeSystem.getInstance(), new CreateTradeLogTableMigration(), new AddIndexTradeLogTableMigration(), new CreatePlayerNameTableMigration());
    }
}

