/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.database.migrations.mysql;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.database.migrations.SqlMigrations;
import de.codingair.tradesystem.spigot.database.migrations.mysql.AddIndexTradeLogTableMigration;
import de.codingair.tradesystem.spigot.database.migrations.mysql.ConvertTimestampToDatetimeMigration;
import de.codingair.tradesystem.spigot.database.migrations.mysql.CreatePlayerNameTableMigration;
import de.codingair.tradesystem.spigot.database.migrations.mysql.CreateTradeLogTableMigration;
import de.codingair.tradesystem.spigot.database.migrations.mysql.MySQLConnection;
import de.codingair.tradesystem.spigot.utils.Supplier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MysqlMigrations
extends SqlMigrations {
    private static MysqlMigrations instance;
    private final Supplier<Connection, SQLException> connection = MySQLConnection.getConnection();

    private MysqlMigrations() {
    }

    @Override
    public void setVersion(@NotNull Connection connection, @NotNull String user, int version) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO migrations VALUES (?, ?) ON DUPLICATE KEY UPDATE version=?;");){
            stmt.setString(1, user);
            stmt.setInt(2, version);
            stmt.setInt(3, version);
            stmt.executeUpdate();
        }
    }

    @Override
    @NotNull
    public Connection getConnection() throws SQLException {
        return this.connection.get();
    }

    @NotNull
    public static MysqlMigrations getInstance() {
        if (instance == null) {
            instance = new MysqlMigrations();
        }
        return instance;
    }

    static {
        MysqlMigrations.getInstance().register(TradeSystem.getInstance(), new CreateTradeLogTableMigration(), new AddIndexTradeLogTableMigration(), new ConvertTimestampToDatetimeMigration(), new CreatePlayerNameTableMigration());
    }
}

