/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.database.migrations.mysql;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.utils.Supplier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.configuration.file.FileConfiguration;

public class MySQLConnection {
    private static final ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
    private static final FileConfiguration config = file.getConfig();
    private static MySQLConnection instance;
    private final String url = config.getString("TradeSystem.Database.MySQL.Connection_URL");
    private final String user = config.getString("TradeSystem.Database.MySQL.User");
    private final String password;

    private MySQLConnection() {
        String password = config.getString("TradeSystem.Database.MySQL.Password");
        if (password != null && password.equalsIgnoreCase("null")) {
            password = null;
        }
        this.password = password;
    }

    @NotNull
    private static MySQLConnection getInstance() {
        if (instance == null) {
            instance = new MySQLConnection();
        }
        return instance;
    }

    @NotNull
    public static Supplier<Connection, SQLException> getConnection() {
        return () -> MySQLConnection.getInstance().buildConnection();
    }

    public static void checkDataSource() throws SQLException {
        MySQLConnection.getConnection().get().close();
    }

    @Nullable
    private Connection buildConnection() throws SQLException {
        if (this.url == null || this.user == null) {
            return null;
        }
        return DriverManager.getConnection(this.url, this.user, this.password);
    }
}

