/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.database.migrations;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.database.migrations.Migration;
import de.codingair.tradesystem.spigot.ext.Extensions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SqlMigrations {
    private final Map<String, List<Migration>> migrations = new HashMap<String, List<Migration>>();

    @NotNull
    public abstract Connection getConnection() throws Exception;

    public abstract void setVersion(@NotNull Connection var1, @NotNull String var2, int var3) throws Exception;

    public void createMigrationTable() throws Exception {
        try (Connection connection = this.getConnection();){
            int migrationVersion = SqlMigrations.getOldMigrationVersion(connection);
            this.createNewMigrationTable(connection, migrationVersion);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getOldMigrationVersion(@NotNull Connection connection) {
        try (Statement stmt = connection.createStatement();){
            String sql = "SELECT max(version) as max FROM migrations WHERE id IS NOT NULL;";
            ResultSet set = stmt.executeQuery(sql);
            if (!set.next()) return 0;
            int n = set.getInt("max");
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void runMigrations() throws Exception {
        try (Connection connect = this.getConnection();){
            connect.setAutoCommit(false);
            Map<String, List<Migration>> migrations = this.getRelevantMigrations();
            String pluginUser = TradeSystem.getInstance().getName().toLowerCase();
            this.runMigrations(connect, pluginUser, migrations.remove(pluginUser));
            for (Map.Entry<String, List<Migration>> e : migrations.entrySet()) {
                this.runMigrations(connect, e.getKey(), e.getValue());
            }
            connect.commit();
        }
    }

    private void runMigrations(@NotNull Connection connect, @NotNull String user, @Nullable List<Migration> migrations) throws Exception {
        if (migrations == null || migrations.isEmpty()) {
            return;
        }
        for (Migration migration : migrations) {
            String[] commands = migration instanceof Migration.MultiMigration ? ((Migration.MultiMigration)migration).getStatements() : new String[]{migration.getStatement()};
            for (String command : commands) {
                try (Statement stmt = connect.createStatement();){
                    stmt.execute(command);
                }
            }
        }
        this.setVersion(connect, user, this.migrations.get(user.toLowerCase()).size());
    }

    private void createNewMigrationTable(@NotNull Connection connection, int previousVersion) throws Exception {
        try (Statement stmt = connection.createStatement();){
            if (previousVersion > 0) {
                stmt.execute("DROP TABLE IF EXISTS migrations;");
            }
            stmt.execute("CREATE TABLE IF NOT EXISTS migrations (user VARCHAR(25) PRIMARY KEY, version integer NOT NULL);");
        }
        if (previousVersion > 0) {
            stmt = connection.prepareStatement("INSERT INTO migrations VALUES (?, ?);");
            try {
                stmt.setString(1, TradeSystem.getInstance().getDescription().getName().toLowerCase());
                stmt.setInt(2, previousVersion);
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    @NotNull
    private Map<String, Integer> getVersions() throws Exception {
        HashMap<String, Integer> versions = new HashMap<String, Integer>();
        try (Connection connect = this.getConnection();
             Statement stmt = connect.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT * FROM migrations;");
            while (resultSet.next()) {
                String name = resultSet.getString("user");
                int version = resultSet.getInt("version");
                versions.put(name, version);
            }
        }
        return versions;
    }

    @NotNull
    private Map<String, List<Migration>> getRelevantMigrations() throws Exception {
        HashMap<String, List<Migration>> relevant = new HashMap<String, List<Migration>>();
        for (Map.Entry<String, List<Migration>> e : this.migrations.entrySet()) {
            List<Migration> m = e.getValue();
            if (m == null) continue;
            int version = this.getVersions().getOrDefault(e.getKey(), 0);
            if (m.size() <= version) continue;
            relevant.put(e.getKey(), m.subList(version, m.size()));
        }
        return relevant;
    }

    public void register(@NotNull JavaPlugin plugin, Migration ... migrations) {
        if (!plugin.equals((Object)TradeSystem.getInstance()) && !Extensions.isSupported(plugin)) {
            TradeSystem.getInstance().getLogger().warning("Plugin '" + plugin.getName() + "' is not a registered extension by TradeSystem. Migrations will not be executed.");
            return;
        }
        String name = plugin.getName().toLowerCase();
        this.migrations.compute(name, (k, v) -> {
            if (v == null) {
                v = new ArrayList();
            }
            Collections.addAll(v, migrations);
            return v;
        });
    }
}

