/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.database;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.database.DatabaseType;
import de.codingair.tradesystem.spigot.database.migrations.SqlMigrations;
import de.codingair.tradesystem.spigot.database.migrations.mysql.MySQLConnection;
import de.codingair.tradesystem.spigot.database.migrations.mysql.MysqlMigrations;
import de.codingair.tradesystem.spigot.database.migrations.sqlite.SqLiteMigrations;
import de.codingair.tradesystem.spigot.database.migrations.sqlite.SqlLiteConnection;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DatabaseHandler {
    private DatabaseType databaseType;
    private boolean running = false;

    public void load() {
        this.loadType();
        TradeSystem.log("  > Queuing database initializing task");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TradeSystem.getInstance(), new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        DatabaseHandler.this.checkCredentials();
                        SqlMigrations sqlMigrations = DatabaseHandler.this.getMigrationHandler();
                        if (sqlMigrations != null) {
                            sqlMigrations.createMigrationTable();
                            sqlMigrations.runMigrations();
                        }
                        TradeSystem.getInstance().getLogger().log(Level.INFO, "Database was started successfully.");
                        DatabaseHandler.this.running = true;
                    }
                    catch (Exception ex) {
                        DatabaseHandler.this.running = false;
                        boolean switchToSQLite = DatabaseHandler.this.databaseType != DatabaseType.SQLITE;
                        TradeSystem.getInstance().getLogger().log(switchToSQLite ? Level.WARNING : Level.SEVERE, "Database could not be started: " + ex.getMessage());
                        if (!switchToSQLite) break block3;
                        TradeSystem.getInstance().getLogger().warning("Switching to SQLite database.");
                        DatabaseHandler.this.setTypeToSQLite();
                        this.run();
                    }
                }
            }
        });
    }

    private boolean defaultCredentials() {
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
        YamlConfiguration config = file.getConfig();
        String defUser = "root";
        String defPassword = "password";
        return defUser.equals(config.getString("TradeSystem.Database.MySQL.User")) && defPassword.equals(config.getString("TradeSystem.Database.MySQL.Password"));
    }

    private void setTypeToSQLite() {
        this.databaseType = DatabaseType.SQLITE;
        boolean persist = this.defaultCredentials();
        if (persist) {
            ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
            YamlConfiguration config = file.getConfig();
            config.set("TradeSystem.Database.Type", (Object)DatabaseType.SQLITE.getName());
            file.saveConfig();
        }
    }

    private void loadType() {
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
        YamlConfiguration config = file.getConfig();
        String databaseType = config.getString("TradeSystem.Database.Type", "SQLITE");
        this.databaseType = DatabaseType.byName(databaseType);
        if (this.databaseType == null) {
            TradeSystem.getInstance().getLogger().warning("Invalid database type configured: " + databaseType + ". Using SQLite instead.");
            this.databaseType = DatabaseType.SQLITE;
        }
    }

    private void checkCredentials() throws Exception {
        switch (this.databaseType) {
            case MYSQL: {
                MySQLConnection.checkDataSource();
                break;
            }
            case SQLITE: {
                SqlLiteConnection.connect().close();
            }
        }
    }

    @Nullable
    private SqlMigrations getMigrationHandler() {
        switch (this.databaseType) {
            case MYSQL: {
                return MysqlMigrations.getInstance();
            }
            case SQLITE: {
                return SqLiteMigrations.getInstance();
            }
        }
        return null;
    }

    public boolean isRunning() {
        return this.running;
    }

    @NotNull
    public DatabaseType getType() {
        return this.databaseType;
    }
}

