/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.commands;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.BaseComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandBuilder;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.special.MultiCommandComponent;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.editor.Editor;
import de.codingair.tradesystem.spigot.trade.gui.layout.LayoutManager;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Name;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TradeSystemCMD
extends CommandBuilder {
    public TradeSystemCMD() {
        super((JavaPlugin)TradeSystem.getInstance(), "tradesystem", "Trade-System-CMD", new BaseComponent("TradeSystem.Modify"){

            @Override
            public void noPermission(CommandSender sender, String label, CommandComponent child) {
                Lang.send(sender, "No_Permissions", new Lang.P[0]);
            }

            @Override
            public void onlyFor(boolean player, CommandSender sender, String label, CommandComponent child) {
                Lang.send(sender, "Only_for_Player", new Lang.P[0]);
            }

            @Override
            public void unknownSubCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem", new Lang.P("label", label));
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem", new Lang.P("label", label));
                return true;
            }
        }, true, "ts");
        final LayoutManager l = TradeSystem.getInstance().getLayoutManager();
        if (!TradeSystem.handler().tradeProxy()) {
            this.getBaseComponent().addChild(new CommandComponent("activateTradeProxy"){

                @Override
                public boolean runCommand(CommandSender sender, String label, String[] args) {
                    sender.sendMessage(Lang.getPrefix() + "\u00a7cWARNING\u00a77. You're about to enable \u00a7eTradeProxy \u00a77for this server. If you don't have \u00a7eTradeProxy\u00a77 installed, you'll be \u00a7cvulnerable to custom payload attacks\u00a77. Run \u00a7c/tradesystem activateTradeProxy confirm\u00a77 if you're sure.");
                    return true;
                }
            });
            this.getComponent("activateTradeProxy").addChild(new CommandComponent("confirm"){

                @Override
                public boolean runCommand(CommandSender sender, String label, String[] args) {
                    ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
                    YamlConfiguration config = file.getConfig();
                    config.set("TradeSystem.TradeProxy", (Object)true);
                    file.saveConfig();
                    TradeSystemCMD.this.getComponent("reload").runCommand(sender, "reload", new String[0]);
                    return true;
                }
            });
        }
        this.getBaseComponent().addChild(new CommandComponent("reload"){

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                try {
                    Lang.send(sender, "Plugin_Reloading", new Lang.P[0]);
                    TradeSystem.getInstance().reload();
                    Lang.send(sender, "Success_Plugin_Reloaded", new Lang.P[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }
        });
        this.getBaseComponent().addChild(new CommandComponent("layout"){

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem_Layout", new Lang.P("label", label));
                return true;
            }
        });
        this.getComponent("layout").addChild(new CommandComponent("create"){

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem_Layout_Create", new Lang.P("label", label));
                return true;
            }
        }.setOnlyPlayers(true));
        this.getComponent("layout", "create").addChild(new MultiCommandComponent(){

            @Override
            public void addArguments(CommandSender commandSender, String[] strings, List<String> list) {
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                if (!l.isAvailable(argument)) {
                    Lang.send(sender, "\u00a77", "Layout_Name_Already_Exists", new Lang.P[0]);
                    return true;
                }
                try {
                    new Editor(argument, (Player)sender).open();
                }
                catch (AlreadyOpenedException | IsWaitingException | NoPageException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }.setOnlyPlayers(true));
        this.getComponent("layout", "create", null).addChild(new MultiCommandComponent(){

            @Override
            public void addArguments(CommandSender commandSender, String[] strings, List<String> list) {
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                int size;
                if (!l.isAvailable(args[2])) {
                    Lang.send(sender, "\u00a77", "Layout_Name_Already_Exists", new Lang.P[0]);
                    return true;
                }
                try {
                    size = Integer.parseInt(argument);
                }
                catch (NumberFormatException e) {
                    Lang.send(sender, "Help_TradeSystem_Layout_Create", new Lang.P("label", label));
                    return true;
                }
                if (size % 9 != 0 || size < 9 || size > 54) {
                    Lang.send(sender, "Help_TradeSystem_Layout_Create", new Lang.P("label", label));
                    return true;
                }
                try {
                    new Editor(args[2], size, (Player)sender).open();
                }
                catch (AlreadyOpenedException | IsWaitingException | NoPageException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }.setOnlyPlayers(true));
        this.getComponent("layout").addChild(new CommandComponent("edit"){

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem_Layout_Edit", new Lang.P("label", label));
                return true;
            }
        }.setOnlyPlayers(true));
        this.getComponent("layout", "edit").addChild(new MultiCommandComponent(){

            @Override
            public void addArguments(CommandSender sender, String[] args, List<String> suggestions) {
                for (Pattern layout : l.getPatterns(true)) {
                    suggestions.add(layout.getName());
                }
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                Pattern pattern = l.getPattern(argument, true);
                if (pattern == null) {
                    Lang.send(sender, "Layout_Does_Not_Exist", new Lang.P[0]);
                    return true;
                }
                try {
                    new Editor(pattern, (Player)sender).open();
                }
                catch (AlreadyOpenedException | IsWaitingException | NoPageException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }.setOnlyPlayers(true));
        this.getComponent("layout").addChild(new CommandComponent("activate"){

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem_Layout_Activate", new Lang.P("label", label));
                return true;
            }
        });
        this.getComponent("layout", "activate").addChild(new MultiCommandComponent(){

            @Override
            public void addArguments(CommandSender sender, String[] args, List<String> suggestions) {
                for (Pattern layout : l.getPatterns()) {
                    suggestions.add(layout.getName());
                }
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                Pattern pattern = l.getPattern(argument);
                if (pattern == null) {
                    Lang.send(sender, "Layout_Does_Not_Exist", new Lang.P[0]);
                    return true;
                }
                if (l.getActive().getName().equals(pattern.getName())) {
                    Lang.send(sender, "Layout_Already_Activated", new Lang.P[0]);
                    return true;
                }
                l.setActive(pattern.getName());
                Lang.send(sender, "Layout_Activated", new Lang.P("name", pattern.getName()));
                return true;
            }
        });
        this.getComponent("layout").addChild(new CommandComponent("delete"){

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Help_TradeSystem_Layout_Delete", new Lang.P("label", label));
                return true;
            }
        });
        this.getComponent("layout", "delete").addChild(new MultiCommandComponent(){

            @Override
            public void addArguments(CommandSender sender, String[] args, List<String> suggestions) {
                for (Pattern layout : l.getPatterns(true)) {
                    suggestions.add(layout.getName());
                }
                for (Name name : l.getCrashedPatterns().keySet()) {
                    suggestions.add(name.toString());
                }
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                Pattern pattern = l.getPattern(argument, true);
                if (pattern == null) {
                    Map<?, ?> data = l.getCrashedPatterns().remove(new Name(argument));
                    if (data != null) {
                        Lang.send(sender, "Layout_Deleted", new Lang.P("name", Pattern.deserializeName(new JSON(data))));
                        return true;
                    }
                    Lang.send(sender, "Layout_Does_Not_Exist", new Lang.P[0]);
                    return true;
                }
                if (pattern.equals(l.getActive())) {
                    l.setActive("Standard");
                }
                l.delete(pattern);
                Lang.send(sender, "Layout_Deleted", new Lang.P("name", pattern.getName()));
                return true;
            }
        });
    }
}

