/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.commands;

import de.codingair.tradesystem.lib.codingapi.server.commands.builder.BaseComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandBuilder;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.special.MultiCommandComponent;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.managers.CommandManager;
import de.codingair.tradesystem.spigot.trade.managers.RequestManager;
import de.codingair.tradesystem.spigot.utils.Lang;
import de.codingair.tradesystem.spigot.utils.Permissions;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TradeCMD
extends CommandBuilder {
    public TradeCMD(String[] aliases, CommandManager commandManager) {
        super((JavaPlugin)TradeSystem.getInstance(), aliases[0], "Trade-System-CMD", new BaseComponent(Permissions.PERMISSION){

            @Override
            public void noPermission(CommandSender sender, String label, CommandComponent child) {
                Lang.send(sender, "\u00a7c", "Not_Able_To_Trade", new Lang.P[0]);
            }

            @Override
            public void onlyFor(boolean player, CommandSender sender, String label, CommandComponent child) {
                Lang.send(sender, "Only_for_Player", new Lang.P[0]);
            }

            @Override
            public void unknownSubCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Command_How_To", new Lang.P[0]);
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String[] args) {
                Lang.send(sender, "Command_How_To", new Lang.P[0]);
                return true;
            }
        }.setOnlyPlayers(true), true, Arrays.copyOfRange(aliases, 1, aliases.length));
        for (String cmd : commandManager.getToggleAliases()) {
            this.getBaseComponent().addChild(new CommandComponent(cmd){

                @Override
                public boolean runCommand(CommandSender sender, String label, String[] args) {
                    return TradeCMD.this.toggle(sender);
                }
            });
        }
        for (String cmd : commandManager.getAcceptAliases()) {
            this.getBaseComponent().addChild(new CommandComponent(cmd){

                @Override
                public boolean runCommand(CommandSender sender, String label, String[] args) {
                    try {
                        TradeSystem.invitations().handleInvitation((Player)sender, null, true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return true;
                }
            });
            this.getComponent(cmd).addChild(new MultiCommandComponent(){

                @Override
                public void addArguments(CommandSender sender, String[] args, List<String> suggestions) {
                    suggestions.addAll(TradeSystem.invitations().getInvitationNames(sender.getName()));
                }

                @Override
                public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                    try {
                        TradeSystem.invitations().handleInvitation((Player)sender, argument, true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return true;
                }
            });
        }
        for (String cmd : commandManager.getDenyAliases()) {
            this.getBaseComponent().addChild(new CommandComponent(cmd){

                @Override
                public boolean runCommand(CommandSender sender, String label, String[] args) {
                    TradeSystem.invitations().handleInvitation((Player)sender, null, false);
                    return true;
                }
            });
            this.getComponent(cmd).addChild(new MultiCommandComponent(){

                @Override
                public void addArguments(CommandSender sender, String[] args, List<String> suggestions) {
                    suggestions.addAll(TradeSystem.invitations().getInvitationNames(sender.getName()));
                }

                @Override
                public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                    TradeSystem.invitations().handleInvitation((Player)sender, argument, false);
                    return true;
                }
            });
        }
        this.getBaseComponent().addChild(new MultiCommandComponent(Permissions.PERMISSION_INITIATE){

            @Override
            public void addArguments(CommandSender sender, String[] args, List<String> suggestions) {
                for (Player player2 : Bukkit.getOnlinePlayers()) {
                    Set<String> invitations;
                    if (player2.getName().equals(sender.getName()) || !((Player)sender).canSee(player2) || (invitations = TradeSystem.invitations().getInvitationNames(player2.getName())).contains(sender.getName().toLowerCase())) continue;
                    suggestions.add(player2.getName());
                }
                TradeSystem.proxy().getPlayers(sender).forEach(player -> {
                    Set<String> l = TradeSystem.invitations().getInvitationNames((String)player);
                    if (l.contains(sender.getName().toLowerCase())) {
                        return;
                    }
                    suggestions.add((String)player);
                });
            }

            @Override
            public boolean runCommand(CommandSender sender, String label, String argument, String[] args) {
                RequestManager.request((Player)sender, argument);
                return true;
            }
        });
    }

    private boolean toggle(CommandSender sender) {
        if (TradeSystem.getInstance().getTradeManager().toggle((Player)sender)) {
            Lang.send(sender, "Trade_Offline", new Lang.P[0]);
            TradeSystem.invitations().clear(sender.getName());
        } else {
            Lang.send(sender, "Trade_Online", new Lang.P[0]);
        }
        return true;
    }
}

