/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.codingapi.files.FileManager;
import de.codingair.tradesystem.lib.codingapi.nms.NmsCheck;
import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButtonManager;
import de.codingair.tradesystem.lib.codingapi.server.specification.Type;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.utils.Value;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.packetmanagement.utils.Proxy;
import de.codingair.tradesystem.spigot.commands.TradeCMD;
import de.codingair.tradesystem.spigot.commands.TradeSystemCMD;
import de.codingair.tradesystem.spigot.database.DatabaseHandler;
import de.codingair.tradesystem.spigot.ext.Extensions;
import de.codingair.tradesystem.spigot.extras.bstats.MetricsManager;
import de.codingair.tradesystem.spigot.extras.external.PluginDependencies;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogCMD;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogListener;
import de.codingair.tradesystem.spigot.trade.TradeHandler;
import de.codingair.tradesystem.spigot.trade.gui.TradeGUIListener;
import de.codingair.tradesystem.spigot.trade.gui.layout.LayoutManager;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconController;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.listeners.ExpirationListener;
import de.codingair.tradesystem.spigot.trade.listeners.JoinNoteListener;
import de.codingair.tradesystem.spigot.trade.listeners.ProxyPayerListener;
import de.codingair.tradesystem.spigot.trade.listeners.PublishSkinListener;
import de.codingair.tradesystem.spigot.trade.listeners.TradeListener;
import de.codingair.tradesystem.spigot.trade.managers.CommandManager;
import de.codingair.tradesystem.spigot.trade.managers.InvitationManager;
import de.codingair.tradesystem.spigot.transfer.ProxyDataHandler;
import de.codingair.tradesystem.spigot.transfer.ProxyDataListener;
import de.codingair.tradesystem.spigot.transfer.SpigotHandler;
import de.codingair.tradesystem.spigot.utils.BackwardSupport;
import de.codingair.tradesystem.spigot.utils.Lang;
import de.codingair.tradesystem.spigot.utils.Permissions;
import de.codingair.tradesystem.spigot.utils.updates.NotifyListener;
import de.codingair.tradesystem.spigot.utils.updates.UpdateNotifier;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class TradeSystem
extends JavaPlugin
implements Proxy {
    private static TradeSystem instance;
    private static IconController iconController;
    private final LayoutManager layoutManager = new LayoutManager();
    private final TradeHandler tradeHandler = new TradeHandler();
    private final DatabaseHandler databaseHandler = new DatabaseHandler();
    private final FileManager fileManager = new FileManager(this);
    private SpigotHandler spigotHandler;
    private final ProxyDataHandler proxyDataHandler = new ProxyDataHandler();
    private final UpdateNotifier updateNotifier = new UpdateNotifier(this.getDescription().getVersion(), "TradeSystem", 58434);
    private boolean needsUpdate = false;
    private CommandManager commandManager;
    private TradeSystemCMD tradeSystemCMD;
    private TradeLogCMD tradeLogCMD;
    private TradeCMD tradeCMD;
    private boolean firstSetup;
    private boolean workingNms = false;
    private YamlConfiguration oldConfig;

    public static void log(String message) {
        Bukkit.getLogger().info(message);
    }

    public static TradeSystem getInstance() {
        return instance;
    }

    public static SpigotHandler proxyHandler() {
        return TradeSystem.instance.spigotHandler;
    }

    public static ProxyDataHandler proxy() {
        return TradeSystem.instance.proxyDataHandler;
    }

    public static DatabaseHandler database() {
        return TradeSystem.instance.databaseHandler;
    }

    public static TradeHandler handler() {
        return TradeSystem.instance.tradeHandler;
    }

    public static InvitationManager invitations() {
        return TradeSystem.handler().getInvitationManager();
    }

    public void onEnable() {
        instance = this;
        if (!this.checkServerVersion()) {
            return;
        }
        this.checkNms();
        API.getInstance().onEnable(this);
        this.printConsoleInfo(() -> {
            this.loadConfigFiles();
            new BackwardSupport();
            IconHandler.init();
            iconController.registerDefault();
            PluginDependencies.enable();
            this.registerDefaultPluginMessagingChannel();
            this.commandManager = new CommandManager(this.getFileManager().getFile("Config"));
            this.loadManagers();
            this.spigotHandler = new SpigotHandler(this);
            this.spigotHandler.onEnable();
            this.proxyDataHandler.onEnable();
            Permissions.checkPermissions(this.firstSetup);
            this.registerCommands();
            this.registerListeners();
            new MetricsManager().start();
            this.afterOnEnable();
            this.startUpdateNotifier();
        });
        this.notifyPlayers(null);
    }

    public void onDisable() {
        if (Version.get() != null && Version.atLeast(20.5) && Version.type() != Type.PAPER) {
            return;
        }
        if (!this.workingNms) {
            this.getLogger().log(Level.SEVERE, "This Minecraft version does not seem to be supported yet. Please contact the author with the given error above.");
            this.getLogger().log(Level.SEVERE, "Here's an invitation to the discord for support: https://discord.gg/DxKMcGjQbp");
            return;
        }
        this.workingNms = false;
        API.getInstance().onDisable(this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.printConsoleInfo(() -> {
            this.tradeHandler.disable();
            this.tradeCMD.unregister();
            this.tradeSystemCMD.unregister();
            if (this.tradeLogCMD != null) {
                this.tradeLogCMD.unregister();
            }
            if (this.spigotHandler != null) {
                this.spigotHandler.onDisable();
            }
            this.proxyDataHandler.onDisable();
            HandlerList.unregisterAll((Plugin)this);
            this.fileManager.destroy();
            PluginDependencies.disable();
            if (iconController != null) {
                iconController.clear();
            }
        });
    }

    private void printConsoleInfo(Runnable runnable) {
        long start = System.currentTimeMillis();
        TradeSystem.log(" ");
        TradeSystem.log("__________________________________________________________");
        TradeSystem.log(" ");
        TradeSystem.log("                       TradeSystem [" + this.getDescription().getVersion() + "]");
        if (this.needsUpdate) {
            TradeSystem.log(" ");
            TradeSystem.log("New update available [v" + this.updateNotifier.getVersion() + " - " + this.updateNotifier.getUpdateInfo() + "]. Download it on \n\n" + this.updateNotifier.getDownloadLink() + "\n");
        }
        TradeSystem.log(" ");
        TradeSystem.log("Status:");
        TradeSystem.log(" ");
        TradeSystem.log("MC-Version: " + Version.get().fullVersion());
        TradeSystem.log(" ");
        runnable.run();
        TradeSystem.log(" ");
        TradeSystem.log("Finished (" + (System.currentTimeMillis() - start) + "ms)");
        TradeSystem.log(" ");
        TradeSystem.log("__________________________________________________________");
        TradeSystem.log(" ");
    }

    private void checkNms() {
        NmsCheck.test(new Class[0]);
        this.workingNms = true;
    }

    private boolean checkServerVersion() {
        if (Version.get() != null && Version.atLeast(20.5) && Version.type() != Type.PAPER) {
            this.getLogger().info("====================");
            this.getLogger().log(Level.SEVERE, "To support faster updates by having less NMS changes, this plugin requires a Paper server as of Minecraft 1.20.5 and upwards!");
            this.getLogger().log(Level.SEVERE, "A fork of Paper does also work.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().info("====================");
            return false;
        }
        return true;
    }

    private void loadManagers() {
        this.tradeHandler.load();
        this.layoutManager.load();
        this.databaseHandler.load();
    }

    private void registerDefaultPluginMessagingChannel() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    private void loadConfigFiles() {
        this.copyConfig();
        this.fileManager.loadFile("Config", "/");
        this.fileManager.loadFile("Layouts", "/");
        Lang.init(this, this.fileManager);
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new NotifyListener(), (Plugin)this);
        TradeListener tradeListener = new TradeListener();
        Bukkit.getPluginManager().registerEvents((Listener)tradeListener, (Plugin)this);
        ChatButtonManager.getInstance().addListener(tradeListener);
        Bukkit.getPluginManager().registerEvents((Listener)new ExpirationListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ProxyPayerListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TradeGUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinNoteListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PublishSkinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ProxyDataListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TradeLogListener(), (Plugin)this);
    }

    private void registerCommands() {
        this.tradeCMD = new TradeCMD(this.commandManager.getTradeAliases(), this.commandManager);
        this.tradeCMD.register();
        this.tradeSystemCMD = new TradeSystemCMD();
        this.tradeSystemCMD.register();
        if (!Extensions.TradeAudit.isEnabled()) {
            this.tradeLogCMD = new TradeLogCMD();
            this.tradeLogCMD.register();
        }
    }

    private void startUpdateNotifier() {
        Value<Object> task = new Value<Object>(null);
        Runnable runnable = () -> {
            this.needsUpdate = this.updateNotifier.read();
            if (this.needsUpdate) {
                TradeSystem.log("-----< TradeSystem >-----");
                TradeSystem.log("New update available [" + this.updateNotifier.getUpdateInfo() + "].");
                TradeSystem.log("You are " + this.updateNotifier.getReleasesBehind() + " release(s) behind.");
                TradeSystem.log("Download it on\n\n" + this.updateNotifier.getDownloadLink() + "\n");
                TradeSystem.log("------------------------");
                ((BukkitTask)task.getValue()).cancel();
            }
        };
        task.setValue(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)TradeSystem.getInstance(), runnable, 72000L, 72000L));
    }

    private void afterOnEnable() {
        Bukkit.getScheduler().runTask((Plugin)this, this::updateCommandList);
    }

    private void updateCommandList() {
        if (Version.get().isBiggerThan(Version.v1_12)) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.updateCommands();
            }
        }
    }

    public void reload() throws FileNotFoundException {
        this.onDisable();
        this.onEnable();
    }

    public void notifyPlayers(Player player) {
        if (player == null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.notifyPlayers(p);
            }
        } else if (this.needsUpdate && player.hasPermission("TradeSystem.Notify")) {
            player.sendMessage("");
            player.sendMessage("");
            player.sendMessage(Lang.getPrefix() + "\u00a77A \u00a7anew update \u00a77is available \u00a78[\u00a7b" + this.updateNotifier.getUpdateInfo() + "\u00a78]\u00a77. You are \u00a7a" + this.updateNotifier.getReleasesBehind() + "\u00a77 release(s) behind. Download it on \u00a7b\u00a7n" + this.updateNotifier.getDownloadLink());
            player.sendMessage("");
            player.sendMessage("");
        }
    }

    private void copyConfig() {
        this.firstSetup = !this.getDataFolder().exists();
        ConfigFile file = this.fileManager.loadFile("Config", "/", false, true);
        this.oldConfig = file.getConfig();
        this.fileManager.unloadFile(file);
    }

    public TradeHandler getTradeManager() {
        return this.tradeHandler;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public YamlConfiguration getOldConfig() {
        return this.oldConfig;
    }

    public DatabaseHandler getDatabaseInitializer() {
        return this.databaseHandler;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public static void setIconController(@NotNull IconController iconController) {
        TradeSystem.iconController = iconController;
    }
}

