/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.proxy.packets;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TradeItemUpdatePacket
implements Packet {
    private String sender;
    private String recipient;
    private byte[] item;
    private int slotId;

    public TradeItemUpdatePacket() {
    }

    public TradeItemUpdatePacket(@NotNull String sender, @NotNull String recipient, byte @Nullable [] item, byte slotId) throws IOException {
        this.sender = sender;
        this.recipient = recipient;
        this.item = item;
        this.slotId = slotId;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.sender);
        out.writeUTF(this.recipient);
        out.writeBoolean(this.item != null);
        if (this.item != null) {
            out.writeShort(this.item.length);
            out.write(this.item, 0, this.item.length);
        }
        out.writeByte(this.slotId);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.sender = in.readUTF();
        this.recipient = in.readUTF();
        boolean notNull = in.readBoolean();
        if (notNull) {
            int length = in.readUnsignedShort();
            this.item = new byte[length];
            in.readFully(this.item);
        }
        this.slotId = in.readUnsignedByte();
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public String getRecipient() {
        return this.recipient;
    }

    public byte @Nullable [] getItem() throws IOException {
        return this.item;
    }

    public int getSlotId() {
        return this.slotId;
    }
}

