/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.proxy.packets;

import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;

public class TradeIconUpdatePacket
implements Packet {
    private String sender;
    private String recipient;
    private int slot;
    private byte[] data;

    public TradeIconUpdatePacket() {
    }

    public TradeIconUpdatePacket(String sender, String recipient, int slot, byte[] data) {
        this.sender = sender;
        this.recipient = recipient;
        this.slot = slot;
        this.data = data;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.sender);
        out.writeUTF(this.recipient);
        out.writeByte(this.slot);
        String encoded = new String(Base64.getEncoder().encode(this.data));
        out.writeUTF(encoded);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.sender = in.readUTF();
        this.recipient = in.readUTF();
        this.slot = in.readUnsignedByte();
        this.data = Base64.getDecoder().decode(in.readUTF());
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public int getSlot() {
        return this.slot;
    }

    public byte[] getData() {
        return this.data;
    }
}

