/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.proxy.packets;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public class PlayerStatePacket
implements Packet {
    private UUID playerId;
    private String playerName;
    private boolean online;

    public PlayerStatePacket() {
    }

    public PlayerStatePacket(@NotNull UUID playerId, @NotNull String playerName, boolean online) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.online = online;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.playerId.getMostSignificantBits());
        out.writeLong(this.playerId.getLeastSignificantBits());
        out.writeUTF(this.playerName);
        out.writeBoolean(this.online);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.playerId = new UUID(in.readLong(), in.readLong());
        this.playerName = in.readUTF();
        this.online = in.readBoolean();
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isOnline() {
        return this.online;
    }
}

