/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.proxy.packets;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.packets.RequestPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.ResponsePacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.ByteMask;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public class InviteResponsePacket
implements RequestPacket<ResultPacket> {
    private String inviter;
    private String responding;
    private UUID respondingId;
    private String respondingServer;
    private String respondingWorld;
    private boolean accept;
    private boolean expire;

    public InviteResponsePacket() {
    }

    public InviteResponsePacket(@NotNull String inviter, @NotNull String responding, @NotNull UUID respondingId, @NotNull String respondingWorld, boolean accept, boolean expire) {
        this.inviter = inviter;
        this.responding = responding;
        this.respondingId = respondingId;
        this.respondingWorld = respondingWorld;
        this.accept = accept;
        this.expire = expire;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.inviter);
        out.writeUTF(this.responding);
        out.writeLong(this.respondingId.getMostSignificantBits());
        out.writeLong(this.respondingId.getLeastSignificantBits());
        ByteMask mask = new ByteMask();
        mask.setBit(0, this.accept);
        mask.setBit(1, this.expire);
        mask.setBit(2, this.respondingServer != null);
        mask.write(out);
        if (this.respondingServer != null) {
            out.writeUTF(this.respondingServer);
        }
        out.writeUTF(this.respondingWorld);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.inviter = in.readUTF();
        this.responding = in.readUTF();
        this.respondingId = new UUID(in.readLong(), in.readLong());
        ByteMask mask = new ByteMask();
        mask.read(in);
        this.accept = mask.getBit(0);
        this.expire = mask.getBit(1);
        if (mask.getBit(2)) {
            this.respondingServer = in.readUTF();
        }
        this.respondingWorld = in.readUTF();
    }

    @NotNull
    public String getInviter() {
        return this.inviter;
    }

    @NotNull
    public String getResponding() {
        return this.responding;
    }

    @NotNull
    public UUID getRespondingId() {
        return this.respondingId;
    }

    public boolean isAccept() {
        return this.accept;
    }

    @NotNull
    public String getRespondingServer() {
        if (this.respondingServer == null) {
            throw new IllegalStateException("TradeProxy did not set responding server!");
        }
        return this.respondingServer;
    }

    public void setRespondingServer(@NotNull String respondingServer) {
        this.respondingServer = respondingServer;
    }

    @NotNull
    public String getRespondingWorld() {
        return this.respondingWorld;
    }

    public InviteResponsePacket setAccept(boolean accept) {
        this.accept = accept;
        return this;
    }

    public boolean isExpire() {
        return this.expire;
    }

    public InviteResponsePacket setExpire(boolean expire) {
        this.expire = expire;
        return this;
    }

    public static class ResultPacket
    implements ResponsePacket {
        private Result result;
        @Nullable
        private String server;
        @Nullable
        private String world;

        public ResultPacket() {
        }

        public ResultPacket(@NotNull Result result, @Nullable String world) {
            this.result = result;
            this.world = world;
        }

        @Override
        public void write(DataOutputStream out) throws IOException {
            out.writeByte(this.result.ordinal());
            ByteMask flags = new ByteMask();
            flags.setBit(0, this.server != null);
            flags.setBit(1, this.world != null);
            flags.write(out);
            if (this.server != null) {
                out.writeUTF(this.server);
            }
            if (this.world != null) {
                out.writeUTF(this.world);
            }
        }

        @Override
        public void read(DataInputStream in) throws IOException {
            this.result = Result.values()[in.readByte()];
            ByteMask flags = new ByteMask();
            flags.read(in);
            if (flags.getBit(0)) {
                this.server = in.readUTF();
            }
            if (flags.getBit(1)) {
                this.world = in.readUTF();
            }
        }

        public Result getResult() {
            return this.result;
        }

        @NotNull
        public String getServer() {
            if (this.server == null) {
                throw new IllegalStateException("Server is null");
            }
            return this.server;
        }

        @NotNull
        public ResultPacket setServer(@NotNull String server) {
            this.server = server;
            return this;
        }

        @NotNull
        public String getWorld() {
            if (this.world == null) {
                throw new IllegalStateException("World is null");
            }
            return this.world;
        }
    }

    public static enum Result {
        SUCCESS,
        NOT_ONLINE,
        OTHER_GROUP;

    }
}

