/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.packetmanagement.variants.gson;

import de.codingair.tradesystem.lib.gson.Gson;
import de.codingair.tradesystem.lib.gson.GsonBuilder;
import de.codingair.tradesystem.lib.gson.JsonDeserializationContext;
import de.codingair.tradesystem.lib.gson.JsonDeserializer;
import de.codingair.tradesystem.lib.gson.JsonElement;
import de.codingair.tradesystem.lib.gson.JsonObject;
import de.codingair.tradesystem.lib.gson.JsonParseException;
import de.codingair.tradesystem.lib.gson.JsonPrimitive;
import de.codingair.tradesystem.lib.gson.JsonSerializationContext;
import de.codingair.tradesystem.lib.gson.JsonSerializer;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.DataHandler;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.UnknownPacketException;
import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import de.codingair.tradesystem.lib.packetmanagement.utils.Direction;
import de.codingair.tradesystem.lib.packetmanagement.utils.FormedPacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.Proxy;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.UUID;

public abstract class GsonDataHandler<C>
extends DataHandler<C, String> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)byte[].class), new ByteArrayToBase64TypeAdapter()).registerTypeAdapter((Type)((Object)Packet.class), new PacketAdapter()).create();

    public GsonDataHandler(@NotNull String channelName, @NotNull Proxy proxy) {
        super(channelName, proxy);
        this.registering();
    }

    protected abstract void registering();

    @Override
    @NotNull
    public FormedPacket convertReceivedData(@NotNull String json, @Nullable C connection, @NotNull Direction direction) {
        return GSON.fromJson(json, FormedPacket.class);
    }

    @Override
    public String serializePacket(@NotNull Packet packet, boolean future, @Nullable UUID uuid) {
        return GSON.toJson(new FormedPacket(packet, future, uuid));
    }

    private static class PacketAdapter
    implements JsonSerializer<Packet>,
    JsonDeserializer<Packet> {
        private PacketAdapter() {
        }

        @Override
        public Packet deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject json = (JsonObject)jsonElement;
            String path = json.getAsJsonPrimitive("type").getAsString();
            try {
                Class<?> clazz = Class.forName(path);
                String data = json.getAsJsonPrimitive("packet").getAsString();
                return (Packet)GSON.fromJson(data, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new UnknownPacketException("Cannot find packet: " + path);
            }
        }

        @Override
        public JsonElement serialize(Packet packet, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject json = new JsonObject();
            json.add("type", new JsonPrimitive(packet.getClass().getName()));
            json.add("packet", new JsonPrimitive(GSON.toJson(packet)));
            return json;
        }
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        @Override
        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.getDecoder().decode(json.getAsString());
        }

        @Override
        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(src));
        }
    }
}

