/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.packetmanagement.variants.bytestream;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.DataHandler;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.MalformedPacketException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.PacketException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.UnknownPacketException;
import de.codingair.tradesystem.lib.packetmanagement.handlers.PacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.packets.AssignedPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.BooleanPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.BytePacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.IntegerPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.LongPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.StringPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.SuccessPacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.Direction;
import de.codingair.tradesystem.lib.packetmanagement.utils.FormedPacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.Proxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.UUID;

public abstract class StreamDataHandler<C>
extends DataHandler<C, byte[]> {
    private final HashMap<Class<? extends Packet>, Short> register = new HashMap();
    private final HashMap<Short, Class<? extends Packet>> registerInverse = new HashMap();
    private Short id;

    public StreamDataHandler(@NotNull String channelName, @NotNull Proxy proxy) {
        super(channelName, proxy);
        this.register();
        this.registering();
        this.id = null;
    }

    private void register() {
        this.id = -6;
        this.registerPacket(SuccessPacket.class);
        this.registerPacket(StringPacket.class);
        this.registerPacket(IntegerPacket.class);
        this.registerPacket(LongPacket.class);
        this.registerPacket(BytePacket.class);
        this.registerPacket(BooleanPacket.class);
    }

    protected abstract void registering();

    protected void registerPacket(@NotNull Class<? extends Packet> sending) {
        if (this.id == null) {
            throw new IllegalStateException("Packet classes cannot be registered on runtime!");
        }
        if (this.register.containsKey(sending)) {
            throw new IllegalStateException("Packet already registered: " + sending);
        }
        if (this.registerInverse.containsKey(this.id)) {
            throw new IllegalStateException("Id already registered: " + this.id);
        }
        this.register.put(sending, this.id);
        this.registerInverse.put(this.id, sending);
        Short s = this.id;
        Short s2 = this.id = Short.valueOf((short)(this.id + 1));
    }

    protected <P extends Packet> void registerPacket(@NotNull Class<? extends P> receiving, @NotNull PacketHandler<P> handler) {
        if (this.id == null) {
            throw new IllegalStateException("Packet classes cannot be registered on runtime!");
        }
        if (this.register.containsKey(receiving)) {
            throw new IllegalStateException("Packet already registered: " + receiving);
        }
        if (this.registerInverse.containsKey(this.id)) {
            throw new IllegalStateException("Id already registered: " + this.id);
        }
        this.register.put(receiving, this.id);
        this.registerInverse.put(this.id, receiving);
        Short s = this.id;
        Short s2 = this.id = Short.valueOf((short)(this.id + 1));
        this.handlers.put(receiving, handler);
    }

    public void registerPacket(short id, @NotNull Class<? extends Packet> sending) {
        if (this.id == null) {
            throw new IllegalStateException("Packet classes cannot be registered on runtime!");
        }
        if (this.register.containsKey(sending)) {
            throw new IllegalStateException("Packet already registered: " + sending);
        }
        if (this.registerInverse.containsKey(id)) {
            throw new IllegalStateException("Id already registered: " + id);
        }
        this.register.put(sending, id);
        this.registerInverse.put(id, sending);
    }

    public <P extends Packet> void registerPacket(short id, @NotNull Class<? extends P> receiving, @NotNull PacketHandler<P> handler) {
        if (this.id == null) {
            throw new IllegalStateException("Packet classes cannot be registered on runtime!");
        }
        if (this.register.containsKey(receiving)) {
            throw new IllegalStateException("Packet already registered: " + receiving);
        }
        if (this.registerInverse.containsKey(id)) {
            throw new IllegalStateException("Id already registered: " + id);
        }
        this.register.put(receiving, id);
        this.registerInverse.put(id, receiving);
        this.handlers.put(receiving, handler);
    }

    @NotNull
    protected <T> T formPacket(short id) throws UnknownPacketException, IllegalAccessException, InstantiationException {
        Class<? extends Packet> c = this.registerInverse.get(id);
        if (c == null) {
            throw new UnknownPacketException("The packet id " + id + " is not associated with a packet class!");
        }
        try {
            return (T)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | NoSuchMethodException | InvocationTargetException e) {
            throw new PacketException("Cannot cast packet to specified object.", e);
        }
    }

    @Override
    @NotNull
    public FormedPacket convertReceivedData(byte @NotNull [] data, @Nullable C connection, @NotNull Direction direction) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            Packet packet = (Packet)this.formPacket(in.readShort());
            boolean future = in.readBoolean();
            UUID id = future && packet instanceof AssignedPacket ? new UUID(in.readLong(), in.readLong()) : null;
            packet.read(in);
            return new FormedPacket(packet, future, id);
        }
        catch (IOException e) {
            throw new MalformedPacketException("Cannot handle bytes to form packet!", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PacketException("Cannot create packet instance!", e);
        }
    }

    @Override
    public byte[] serializePacket(@NotNull Packet packet, boolean future, @Nullable UUID uuid) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        Short id = this.register.get(packet.getClass());
        if (id == null) {
            throw new UnknownPacketException(packet.getClass() + " is not registered!");
        }
        try {
            out.writeShort(id.shortValue());
            out.writeBoolean(future);
            if (uuid != null) {
                out.writeLong(uuid.getMostSignificantBits());
                out.writeLong(uuid.getLeastSignificantBits());
            }
            packet.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stream.toByteArray();
    }
}

