/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.packetmanagement.utils;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.utils.Serializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SerializedGeneric
implements Serializable {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private byte[] object;

    public SerializedGeneric() {
    }

    public SerializedGeneric(@NotNull Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Generic.write(dos, object);
        this.object = baos.toByteArray();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        byte[] data = Base64.getEncoder().encode(this.getData());
        out.writeUTF(new String(data, CHARSET));
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.object = Base64.getDecoder().decode(in.readUTF().getBytes(CHARSET));
    }

    public byte[] getData() {
        return this.object;
    }

    @NotNull
    public <T> T getObject() throws IOException {
        DataInputStream dis = this.asStream();
        return (T)Generic.read(dis);
    }

    @NotNull
    private DataInputStream asStream() {
        return new DataInputStream(new ByteArrayInputStream(this.getData()));
    }

    public static class UnsupportedTypeException
    extends IllegalStateException {
        private final Object o;

        public UnsupportedTypeException(@Nullable Object key, @NotNull Object o) {
            super("Object " + o + " is not a generic! Class: " + o.getClass().getName() + (key == null ? "" : " (Key: '" + key + "')"));
            this.o = o;
        }
    }

    private static enum Generic {
        BYTE(Byte.class, new GenericHandler<Byte>(){

            @Override
            public void handling(DataOutputStream out, Byte o) throws IOException {
                out.writeByte(o.byteValue());
            }

            @Override
            @NotNull
            public Byte read(DataInputStream in) throws IOException {
                return in.readByte();
            }

            @Override
            public Byte getDefault() {
                return (byte)0;
            }
        }),
        SHORT(Short.class, new GenericHandler<Short>(){

            @Override
            public void handling(DataOutputStream out, Short o) throws IOException {
                out.writeShort(o.shortValue());
            }

            @Override
            @NotNull
            public Short read(DataInputStream in) throws IOException {
                return in.readShort();
            }

            @Override
            public Short getDefault() {
                return (short)0;
            }
        }),
        INT(Integer.class, new GenericHandler<Integer>(){

            @Override
            public void handling(DataOutputStream out, Integer o) throws IOException {
                out.writeInt(o);
            }

            @Override
            @NotNull
            public Integer read(DataInputStream in) throws IOException {
                return in.readInt();
            }

            @Override
            public Integer getDefault() {
                return 0;
            }
        }),
        LONG(Long.class, new GenericHandler<Long>(){

            @Override
            public void handling(DataOutputStream out, Long o) throws IOException {
                out.writeLong(o);
            }

            @Override
            @NotNull
            public Long read(DataInputStream in) throws IOException {
                return in.readLong();
            }

            @Override
            public Long getDefault() {
                return 0L;
            }
        }),
        FLOAT(Float.class, new GenericHandler<Float>(){

            @Override
            public void handling(DataOutputStream out, Float o) throws IOException {
                out.writeFloat(o.floatValue());
            }

            @Override
            @NotNull
            public Float read(DataInputStream in) throws IOException {
                return Float.valueOf(in.readFloat());
            }

            @Override
            public Float getDefault() {
                return Float.valueOf(0.0f);
            }
        }),
        DOUBLE(Double.class, new GenericHandler<Double>(){

            @Override
            public void handling(DataOutputStream out, Double o) throws IOException {
                out.writeDouble(o);
            }

            @Override
            @NotNull
            public Double read(DataInputStream in) throws IOException {
                return in.readDouble();
            }

            @Override
            public Double getDefault() {
                return 0.0;
            }
        }),
        BOOLEAN(Boolean.class, new GenericHandler<Boolean>(){

            @Override
            public void handling(DataOutputStream out, Boolean o) throws IOException {
                out.writeBoolean(o);
            }

            @Override
            @NotNull
            public Boolean read(DataInputStream in) throws IOException {
                return in.readBoolean();
            }

            @Override
            public Boolean getDefault() {
                return false;
            }
        }),
        STRING(String.class, new GenericHandler<String>(){

            @Override
            public void handling(DataOutputStream out, String o) throws IOException {
                out.writeUTF(o);
            }

            @Override
            @NotNull
            public String read(DataInputStream in) throws IOException {
                return in.readUTF();
            }

            @Override
            public String getDefault() {
                return null;
            }
        }),
        LINKED_MAP(LinkedHashMap.class, new MapHandler<LinkedHashMap>(LinkedHashMap::new)),
        MAP(Map.class, new MapHandler<Map>(HashMap::new)),
        Set(Set.class, new CollectionHandler<Set>(HashSet::new)),
        LIST(List.class, new CollectionHandler<List>(ArrayList::new)),
        UNKNOWN(null, new GenericHandler<Object>(){

            private void fields(Class<?> c, Consumer<Field> consumer) throws IOException {
                for (Field f : c.getDeclaredFields()) {
                    int flags = f.getModifiers();
                    if (Modifier.isStatic(flags) || Modifier.isTransient(flags)) continue;
                    f.setAccessible(true);
                    try {
                        Field modifiersField = Field.class.getDeclaredField("modifiers");
                        modifiersField.setAccessible(true);
                        modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                    try {
                        consumer.accept(f);
                    }
                    catch (RuntimeException ex) {
                        if (ex.getCause() instanceof IOException) {
                            throw (IOException)ex.getCause();
                        }
                        throw ex;
                    }
                }
                if (c.getSuperclass() != null) {
                    this.fields(c.getSuperclass(), consumer);
                }
            }

            @Override
            protected void handling(DataOutputStream out, Object o) throws IOException {
                out.writeUTF(o.getClass().getName());
                this.fields(o.getClass(), field -> {
                    try {
                        Generic.write(out, field.get(o));
                    }
                    catch (IOException | IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            @Override
            @NotNull
            public Object read(DataInputStream in) throws IOException {
                String path = in.readUTF();
                try {
                    Constructor con;
                    Class<?> c = Class.forName(path);
                    try {
                        con = c.getDeclaredConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        con = Arrays.stream(c.getDeclaredConstructors()).min(Comparator.comparingInt(Constructor::getParameterCount)).orElseThrow(() -> new NoSuchMethodException("No constructor found for " + c.getName()));
                    }
                    con.setAccessible(true);
                    Class<?>[] para = con.getParameterTypes();
                    Object[] os = new Object[para.length];
                    if (para.length > 0) {
                        for (int i = 0; i < para.length; ++i) {
                            os[i] = Generic.getBy(para[i]).handler.getDefault();
                        }
                    }
                    Object o = con.newInstance(os);
                    this.fields(o.getClass(), field -> {
                        try {
                            field.set(o, Generic.read(in));
                        }
                        catch (IOException | IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    return o;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public Object getDefault() {
                return null;
            }
        }),
        ENUM(Enum.class, new GenericHandler<Enum>(){

            @Override
            protected void handling(DataOutputStream out, Enum o) throws IOException {
                out.writeUTF(o.getClass().getName());
                out.writeUTF(o.name());
            }

            @Override
            @NotNull
            public Enum<?> read(DataInputStream in) throws IOException {
                String path = in.readUTF();
                String name = in.readUTF();
                try {
                    Class<?> c = Class.forName(path);
                    if (c.isEnum()) {
                        return Enum.valueOf(c, name);
                    }
                    throw new IllegalStateException("Class " + path + " is not an enum");
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public Enum<?> getDefault() {
                return null;
            }
        });

        private final Class<?> generic;
        private final GenericHandler<?> handler;

        private <G> Generic(Class<G> generic, GenericHandler<G> handler) {
            this.generic = generic;
            this.handler = handler;
        }

        private static Generic getBy(Object o) {
            return Generic.getBy(o.getClass());
        }

        private static Class<?> toNonPrimitive(Class<?> c) {
            if (c == Byte.TYPE) {
                return Byte.class;
            }
            if (c == Short.TYPE) {
                return Short.class;
            }
            if (c == Integer.TYPE) {
                return Integer.class;
            }
            if (c == Long.TYPE) {
                return Long.class;
            }
            if (c == Float.TYPE) {
                return Float.class;
            }
            if (c == Double.TYPE) {
                return Double.class;
            }
            if (c == Boolean.TYPE) {
                return Boolean.class;
            }
            return c;
        }

        private static Generic getBy(Class<?> c) {
            c = Generic.toNonPrimitive(c);
            for (Generic value : Generic.values()) {
                if (value.generic == null || value.generic != c && !value.generic.isAssignableFrom(c)) continue;
                return value;
            }
            return UNKNOWN;
        }

        public static void write(DataOutputStream out, Object o) throws IOException {
            Generic g = Generic.getBy(o);
            out.writeByte(g.ordinal());
            g.handler.write(out, o);
        }

        @NotNull
        public static Object read(DataInputStream in) throws IOException {
            int id = in.readUnsignedByte();
            return Generic.values()[id].handler.read(in);
        }

        private static abstract class GenericHandler<G> {
            private GenericHandler() {
            }

            public void write(DataOutputStream out, Object o) throws IOException {
                this.handling(out, o);
            }

            protected abstract void handling(DataOutputStream var1, G var2) throws IOException;

            @NotNull
            public abstract G read(DataInputStream var1) throws IOException;

            public abstract G getDefault();
        }

        private static class CollectionHandler<C extends Collection<Object>>
        extends GenericHandler<C> {
            private final Supplier<C> collectionInstance;

            public CollectionHandler(Supplier<C> collectionInstance) {
                this.collectionInstance = collectionInstance;
            }

            @Override
            public void handling(DataOutputStream out, C collection) throws IOException {
                int size = collection.size();
                if (size > 65535) {
                    throw new IllegalArgumentException("Cannot serialize lists with a size > 65.535!");
                }
                out.writeShort(size);
                for (Object data : collection) {
                    Generic.write(out, data);
                }
            }

            @Override
            @NotNull
            public C read(DataInputStream in) throws IOException {
                Collection list = (Collection)this.collectionInstance.get();
                int size = in.readUnsignedShort();
                for (int i = 0; i < size; ++i) {
                    list.add(Generic.read(in));
                }
                return (C)list;
            }

            @Override
            public C getDefault() {
                return (C)((Collection)this.collectionInstance.get());
            }
        }

        private static class MapHandler<M extends Map<Object, Object>>
        extends GenericHandler<M> {
            private final Supplier<M> mapInstance;

            public MapHandler(Supplier<M> mapInstance) {
                this.mapInstance = mapInstance;
            }

            @Override
            public void handling(DataOutputStream out, M map) throws IOException {
                int size = map.size();
                if (size > 65535) {
                    throw new IllegalArgumentException("Cannot serialize maps with a size > 65.535!");
                }
                out.writeShort(size);
                for (Map.Entry e : map.entrySet()) {
                    Generic.write(out, e.getKey());
                    try {
                        Generic.write(out, e.getValue());
                    }
                    catch (UnsupportedTypeException ex) {
                        throw new UnsupportedTypeException(e.getKey(), ex.o);
                    }
                }
            }

            @Override
            @NotNull
            public M read(DataInputStream in) throws IOException {
                Map data = (Map)this.mapInstance.get();
                int size = in.readUnsignedShort();
                for (int i = 0; i < size; ++i) {
                    data.put(Generic.read(in), Generic.read(in));
                }
                return (M)data;
            }

            @Override
            public M getDefault() {
                return (M)((Map)this.mapInstance.get());
            }
        }
    }
}

