/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.packetmanagement.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class ObjectMerger<A> {
    private final int results;
    private final BiFunction<A, A, A> merger;
    private final List<A> objects;

    public ObjectMerger(int results, BiFunction<A, A, A> merger) {
        this.results = results;
        this.merger = merger;
        this.objects = new ArrayList<A>(results);
    }

    public boolean append(A object) {
        if (this.objects.size() == this.results) {
            return false;
        }
        this.objects.add(object);
        return this.objects.size() == this.results;
    }

    public A complete(A def) {
        Object result = null;
        for (A f : this.objects) {
            if (result == null) {
                result = f;
                continue;
            }
            result = this.merger.apply(result, f);
        }
        return (A)(result == null ? def : result);
    }
}

