/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.packetmanagement.exceptions;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.PacketException;
import de.codingair.tradesystem.lib.packetmanagement.handlers.PacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.handlers.ResponsiblePacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import de.codingair.tradesystem.lib.packetmanagement.packets.RequestPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.ResponsePacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.Direction;
import de.codingair.tradesystem.lib.packetmanagement.utils.PacketSupplier;
import java.util.concurrent.CompletableFuture;

public class Escalation
extends PacketException {
    private final PacketHandler<?> handler;
    private final Direction direction;
    private final Packet forward;
    private final PacketSupplier<? extends ResponsePacket> exceptional;
    private final CompletableFuture<? extends ResponsePacket> future;
    private final long timeOut;

    public Escalation(@NotNull PacketHandler<?> handler, @NotNull Direction direction, @NotNull Packet forward) {
        this.handler = handler;
        this.direction = direction;
        this.forward = forward;
        this.exceptional = null;
        this.timeOut = 0L;
        this.future = null;
    }

    public <A extends ResponsePacket, P extends RequestPacket<A>> Escalation(@NotNull ResponsiblePacketHandler<P, A> handler, @NotNull Direction direction, @NotNull P forward, @NotNull PacketSupplier<A> exceptional) {
        this(handler, direction, forward, exceptional, -1L);
    }

    public <A extends ResponsePacket, P extends RequestPacket<A>> Escalation(@NotNull ResponsiblePacketHandler<P, A> handler, @NotNull Direction direction, @NotNull P forward, @NotNull PacketSupplier<A> exceptional, long timeOut) {
        this.handler = handler;
        this.direction = direction;
        this.forward = forward;
        this.timeOut = timeOut;
        this.future = forward.buildFuture();
        this.exceptional = exceptional;
    }

    public PacketHandler<?> handler() {
        return this.handler;
    }

    public Direction direction() {
        return this.direction;
    }

    public Packet packet() {
        return this.forward;
    }

    public CompletableFuture<? extends ResponsePacket> future() {
        return this.future;
    }

    public long timeOut(long def) {
        return this.timeOut == -1L ? def : this.timeOut;
    }

    public ResponsePacket exceptional(Throwable err) {
        return this.exceptional.exceptional(err);
    }
}

