/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.packetmanagement;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.Escalation;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.HandlerException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.HandlerResponseException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.NoConnectionException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.NoHandlerException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.TimeOutException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.UnknownPacketException;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.UnsupportedIdException;
import de.codingair.tradesystem.lib.packetmanagement.handlers.MultiLayerPacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.handlers.PacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.handlers.ResponsibleMultiLayerPacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.handlers.ResponsiblePacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.packets.AssignedPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.IgnoreFuture;
import de.codingair.tradesystem.lib.packetmanagement.packets.MergeFuture;
import de.codingair.tradesystem.lib.packetmanagement.packets.Packet;
import de.codingair.tradesystem.lib.packetmanagement.packets.RequestPacket;
import de.codingair.tradesystem.lib.packetmanagement.packets.ResponsePacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.Direction;
import de.codingair.tradesystem.lib.packetmanagement.utils.FormedPacket;
import de.codingair.tradesystem.lib.packetmanagement.utils.ObjectMerger;
import de.codingair.tradesystem.lib.packetmanagement.utils.Proxy;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DataHandler<C, D> {
    protected final String channelBackend;
    protected final String channelProxy;
    protected final ConcurrentHashMap<UUID, CompletableFuture<? extends ResponsePacket>> future = new ConcurrentHashMap();
    protected final ConcurrentHashMap<UUID, ObjectMerger<?>> keep = new ConcurrentHashMap();
    protected final ConcurrentHashMap<UUID, Long> timeSpecific = new ConcurrentHashMap();
    protected final Proxy proxy;
    protected final HashMap<Class<? extends Packet>, PacketHandler<?>> handlers = new HashMap();
    protected long timeOut = 250L;
    private boolean ignoreUnregistered = false;
    private Timer timeOutTimer = new Timer("DataHandler-TimeOut");
    private boolean running = false;

    public DataHandler(@NotNull String channelName, @NotNull Proxy proxy) {
        this.proxy = proxy;
        this.channelBackend = channelName + ":backend";
        this.channelProxy = channelName + ":proxy";
    }

    protected abstract boolean isConnected(Direction var1);

    public <P extends Packet> boolean registerHandler(@NotNull Class<? extends P> receiving, @NotNull PacketHandler<P> handler) {
        return this.handlers.put(receiving, handler) == null;
    }

    protected abstract void send(D var1, C var2, Direction var3);

    public void send(@NotNull Packet packet, @Nullable C connection, @NotNull Direction direction) {
        this.send(packet, connection, direction, null);
    }

    void send(@NotNull Packet packet, @Nullable C connection, @NotNull Direction direction, @Nullable UUID id) {
        this.send(this.processPacket(packet, id), connection, direction);
    }

    public <A extends ResponsePacket> CompletableFuture<A> send(@NotNull RequestPacket<A> packet, @Nullable C connection, @NotNull Direction direction) {
        return this.send(packet, connection, direction, 0L);
    }

    public <A extends ResponsePacket> CompletableFuture<A> send(@NotNull RequestPacket<A> packet, @Nullable C connection, @NotNull Direction direction, long timeOut) {
        CompletableFuture<A> future = packet.buildFuture();
        if (!this.isConnected(direction)) {
            future.completeExceptionally(new NoConnectionException("No " + direction.name() + " connection established!"));
            return future;
        }
        this.send(this.processPacket(packet, this.registerFuture(timeOut, future)), connection, direction);
        return future;
    }

    public void flush() {
        if (this.running) {
            this.timeOutTimer.cancel();
            this.timeOutTimer.purge();
            this.timeOutTimer = new Timer("DataHandler-TimeOut");
            this.running = false;
        }
        this.timeSpecific.clear();
        this.future.clear();
    }

    UUID generateID() {
        UUID id;
        while (this.future.containsKey(id = UUID.randomUUID())) {
        }
        return id;
    }

    @NotNull
    <P extends Packet, H extends PacketHandler<P>> H formHandler(P packet) throws NoHandlerException {
        PacketHandler<?> handler = this.handlers.get(packet.getClass());
        if (handler == null) {
            throw new NoHandlerException(packet.getClass());
        }
        try {
            return (H)handler;
        }
        catch (ClassCastException e) {
            throw new HandlerException("PacketHandler " + handler + " cannot be used for packet " + packet.getClass() + "!", e);
        }
    }

    @NotNull
    public abstract FormedPacket convertReceivedData(@NotNull D var1, @Nullable C var2, @NotNull Direction var3);

    public <A extends ResponsePacket> void receive(@NotNull D data, @Nullable C connection, @NotNull Direction direction) {
        block19: {
            FormedPacket formedPacket;
            try {
                formedPacket = this.convertReceivedData(data, connection, direction);
            }
            catch (UnknownPacketException ex) {
                if (this.ignoreUnregistered) {
                    return;
                }
                throw ex;
            }
            Packet packet = formedPacket.getPacket();
            boolean future = formedPacket.hasFuture();
            UUID id = formedPacket.getFutureId();
            try {
                if (future && packet instanceof ResponsePacket) {
                    this.receiveResponse((ResponsePacket)packet, id);
                    break block19;
                }
                if (future && packet instanceof RequestPacket) {
                    RequestPacket ap = (RequestPacket)packet;
                    ResponsiblePacketHandler handler = (ResponsiblePacketHandler)this.formHandler(ap);
                    if (handler instanceof ResponsibleMultiLayerPacketHandler) {
                        ResponsibleMultiLayerPacketHandler multi = (ResponsibleMultiLayerPacketHandler)handler;
                        if (!multi.answer(ap, this.proxy, direction)) break block19;
                        try {
                            multi.response(ap, this.proxy, connection, direction).thenAccept(response -> this.send((Packet)response, connection, direction, id));
                        }
                        catch (Escalation e) {
                            Packet escalation = e.packet();
                            if (escalation instanceof RequestPacket) {
                                e.future().whenComplete((response, err) -> {
                                    if (err != null) {
                                        this.send(e.exceptional((Throwable)err), connection, direction, id);
                                    } else {
                                        this.send((Packet)response, connection, direction, id);
                                    }
                                });
                                if (!this.isConnected(e.direction())) {
                                    e.future().completeExceptionally(new NoConnectionException("No " + e.direction().name() + " connection established!"));
                                } else {
                                    this.send(this.processPacket(e.packet(), this.registerFuture(e.timeOut(this.timeOut), e.future())), connection, e.direction());
                                }
                                break block19;
                            }
                            this.send(this.processPacket(e.packet(), null), connection, e.direction());
                        }
                        break block19;
                    }
                    if (handler.answer(ap, this.proxy, direction)) {
                        handler.response(ap, this.proxy, connection, direction).thenAccept(response -> this.send((Packet)response, connection, direction, id));
                    }
                    break block19;
                }
                Object handler = this.formHandler(packet);
                if (handler instanceof MultiLayerPacketHandler) {
                    MultiLayerPacketHandler multi = (MultiLayerPacketHandler)handler;
                    try {
                        multi.process(packet, this.proxy, connection, direction);
                    }
                    catch (Escalation e) {
                        this.send(e.packet(), connection, e.direction());
                    }
                } else {
                    handler.process((Packet)packet, this.proxy, connection, direction);
                }
            }
            catch (NoHandlerException ex) {
                if (this.ignoreUnregistered) {
                    return;
                }
                throw ex;
            }
        }
    }

    protected final <A extends ResponsePacket> void receiveResponse(A packet, UUID id) {
        ObjectMerger<?> merger = this.keep.get(id);
        if (merger != null) {
            if (merger.append(packet)) {
                packet = (ResponsePacket)merger.complete(packet);
            } else {
                return;
            }
        }
        this.timeSpecific.remove(id);
        CompletableFuture<? extends ResponsePacket> cf = this.future.remove(id);
        if (cf == null) {
            return;
        }
        try {
            CompletableFuture<? extends ResponsePacket> future = cf;
            future.complete((ResponsePacket)packet);
        }
        catch (ClassCastException e) {
            throw new HandlerResponseException("Response " + packet.getClass() + " does not fit to completable future " + this.future.getClass() + ". Check the response of your packet handler!", e);
        }
    }

    UUID registerFuture(long timeOut, @NotNull CompletableFuture<? extends ResponsePacket> future) {
        UUID id = this.generateID();
        if (timeOut > 0L) {
            if (!this.running) {
                this.checkTimer();
            }
            this.timeSpecific.put(id, timeOut + System.currentTimeMillis());
        }
        this.future.put(id, future);
        return id;
    }

    public abstract D serializePacket(@NotNull Packet var1, boolean var2, @Nullable UUID var3);

    private D processPacket(@NotNull Packet packet, @Nullable UUID uuid) {
        boolean future = true;
        if (packet instanceof IgnoreFuture) {
            future = false;
            packet = ((IgnoreFuture)packet).getPacket();
        } else if (packet instanceof MergeFuture) {
            MergeFuture options = (MergeFuture)packet;
            packet = ((MergeFuture)packet).getPacket();
            this.registerOutgoingPacket(packet, uuid, options);
        }
        if (future && packet instanceof AssignedPacket) {
            if (uuid == null) {
                throw new NullPointerException("Cannot send assigned packet without UUID: " + packet.getClass());
            }
        } else if (uuid != null) {
            throw new UnsupportedIdException("Cannot send id (" + uuid + ") for unsupported packet class: " + packet.getClass());
        }
        return this.serializePacket(packet, future, uuid);
    }

    protected void registerOutgoingPacket(Packet packet, @Nullable UUID uuid, MergeFuture<?> options) {
        if (uuid == null) {
            throw new NullPointerException("Cannot send KeepFuture packet without UUID: " + packet.getClass());
        }
        this.keep.put(uuid, new ObjectMerger(options.getResults(), options.getMerger()));
    }

    private synchronized void checkTimer() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.timeOutTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                DataHandler.this.timeSpecific.entrySet().removeIf(e -> {
                    if (time >= (Long)e.getValue()) {
                        ObjectMerger<?> merger = DataHandler.this.keep.remove(e.getKey());
                        CompletableFuture<? extends ResponsePacket> cf = DataHandler.this.future.remove(e.getKey());
                        if (cf != null) {
                            cf.completeExceptionally(new TimeOutException("The requested packet took too long.", merger));
                        }
                        return true;
                    }
                    return false;
                });
            }
        }, this.timeOut, this.timeOut);
    }

    public String getChannelProxy() {
        return this.channelProxy;
    }

    public String getChannelBackend() {
        return this.channelBackend;
    }

    public <P extends Proxy> P getProxy() {
        return (P)this.proxy;
    }

    public boolean isIgnoreUnregistered() {
        return this.ignoreUnregistered;
    }

    public DataHandler<C, D> setIgnoreUnregistered(boolean ignoreUnregistered) {
        this.ignoreUnregistered = ignoreUnregistered;
        return this;
    }
}

