/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.utils;

import de.codingair.tradesystem.lib.codingapi.server.DefaultFontInfo;
import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public enum TextAlignment {
    LEFT,
    CENTER,
    JUSTIFY;

    private static final int CENTER_PX = 154;
    private static final int MAX_PX = 250;

    public List<String> apply(List<String> lines) {
        if (this.equals((Object)CENTER)) {
            return this.center(lines);
        }
        if (this.equals((Object)JUSTIFY)) {
            return this.justify(lines);
        }
        return new ArrayList<String>(lines);
    }

    public List<String> apply(String ... lines) {
        return this.apply(Arrays.asList(lines));
    }

    private static int getLength(String text) {
        boolean isBold = false;
        boolean isColor = false;
        if (text == null) {
            return 0;
        }
        int length = 0;
        text = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        for (char c : text.toCharArray()) {
            if (c == '\u00a7') {
                isColor = true;
                continue;
            }
            if (isColor) {
                isColor = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            length += isBold ? dFI.getBoldLength() : dFI.getLength();
        }
        return length;
    }

    private List<String> justify(List<String> lines) {
        int longestLine = 0;
        for (String line : lines) {
            int length;
            if (line == null || longestLine >= (length = TextAlignment.getLength(line))) continue;
            longestLine = length;
        }
        ArrayList<String> configured = new ArrayList<String>();
        int lineIndex = 0;
        for (String line : lines) {
            if (lineIndex == lines.size() - 1) break;
            ++lineIndex;
            if (line == null) {
                configured.add(null);
                continue;
            }
            String[] words = line.split(" ");
            if (words.length <= 1) {
                configured.add(line);
                continue;
            }
            int messagePxSize = TextAlignment.getLength(line);
            int toCompensate = longestLine - messagePxSize;
            int afterWord = toCompensate / (words.length - 1);
            int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
            StringBuilder sb = new StringBuilder();
            for (int compensated = 0; compensated < afterWord; compensated += spaceLength) {
                sb.append(" ");
            }
            StringBuilder newLine = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                if (i + 1 == words.length) {
                    newLine.append(words[i]);
                    continue;
                }
                newLine.append(words[i]).append(sb.toString().length() == 0 ? " " : sb.toString());
            }
            configured.add(newLine.toString());
        }
        return configured;
    }

    private List<String> center(List<String> lines) {
        int longestLine = 0;
        String l = null;
        for (String line : lines) {
            int length;
            if (line == null || longestLine >= (length = DefaultFontInfo.getExactLength(line))) continue;
            longestLine = length;
            l = line;
        }
        ArrayList<String> configured = new ArrayList<String>();
        for (String line : lines) {
            if (line == null) continue;
            int messagePxSize = DefaultFontInfo.getExactLength(line);
            int toCompensate = (longestLine - messagePxSize) / 2 / DefaultFontInfo.SPACE.getLength();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < toCompensate; ++i) {
                sb.append(" ");
            }
            configured.add(sb + line);
        }
        return configured;
    }

    public static List<String> lineBreak(String text, int length) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || length >= TextAlignment.getLength(text)) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        int cells = 0;
        StringBuilder line = new StringBuilder();
        String[] lastColor = new String[]{"", ""};
        for (String word : words) {
            boolean isBold = false;
            boolean isColor = false;
            String temp = ChatColor.getLastFullColor(word = word + " ", '\u00a7');
            lastColor[1] = temp.isEmpty() ? lastColor[1] : temp;
            for (char c : word.toCharArray()) {
                if (c == '\u00a7') {
                    isColor = true;
                    continue;
                }
                if (!isColor) {
                    DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
                    cells += isBold ? dFI.getBoldLength() : dFI.getLength();
                    continue;
                }
                isColor = false;
            }
            line.append(word);
            if (cells < length) continue;
            line = new StringBuilder(line.substring(0, line.length() - 1));
            lines.add(lastColor[0] + line);
            line = new StringBuilder();
            cells = 0;
            if (lastColor[1].isEmpty()) continue;
            lastColor[0] = lastColor[1];
            lastColor[1] = "";
        }
        if (line.length() > 0) {
            lines.add(lastColor[0] + line);
        }
        return lines;
    }

    public static void sendCenteredMessage(Player player, String message) {
        if (message == null || message.equals("")) {
            player.sendMessage("");
        }
        message = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        player.sendMessage(sb + message);
    }

    public static void sendCenteredMessage(Player player, BaseComponent base) {
        String message = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)base.toLegacyText());
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
            } else if (c != ' ') {
                DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
                messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
                ++messagePxSize;
            }
            if (messagePxSize < 250) continue;
            return;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        TextComponent spaceBase = new TextComponent(sb.toString());
        spaceBase.addExtra(base);
        player.spigot().sendMessage((BaseComponent)spaceBase);
    }
}

