/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ChatColor
extends Enum<ChatColor> {
    public static final /* enum */ ChatColor BLACK;
    public static final /* enum */ ChatColor DARK_BLUE;
    public static final /* enum */ ChatColor DARK_GREEN;
    public static final /* enum */ ChatColor DARK_AQUA;
    public static final /* enum */ ChatColor DARK_RED;
    public static final /* enum */ ChatColor DARK_PURPLE;
    public static final /* enum */ ChatColor GOLD;
    public static final /* enum */ ChatColor GRAY;
    public static final /* enum */ ChatColor DARK_GRAY;
    public static final /* enum */ ChatColor BLUE;
    public static final /* enum */ ChatColor GREEN;
    public static final /* enum */ ChatColor AQUA;
    public static final /* enum */ ChatColor RED;
    public static final /* enum */ ChatColor LIGHT_PURPLE;
    public static final /* enum */ ChatColor YELLOW;
    public static final /* enum */ ChatColor WHITE;
    public static final /* enum */ ChatColor MAGIC;
    public static final /* enum */ ChatColor BOLD;
    public static final /* enum */ ChatColor STRIKETHROUGH;
    public static final /* enum */ ChatColor UNDERLINE;
    public static final /* enum */ ChatColor ITALIC;
    public static final /* enum */ ChatColor RESET;
    public static final char COLOR_CHAR = '\u00a7';
    public static final String ALL_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRr";
    public static final String ALL_HEX_CODES = "0123456789AaBbCcDdEeFf";
    public static final Pattern STRIP_COLOR_PATTERN;
    private static final Map<Character, ChatColor> BY_CHAR;
    private final char code;
    private final String toString;
    private final String name;
    private static final /* synthetic */ ChatColor[] $VALUES;

    public static ChatColor[] values() {
        return (ChatColor[])$VALUES.clone();
    }

    public static ChatColor valueOf(String name) {
        return Enum.valueOf(ChatColor.class, name);
    }

    private ChatColor(char code, String name) {
        this.code = code;
        this.name = name;
        this.toString = new String(new char[]{'\u00a7', code});
    }

    public String toString() {
        return this.toString;
    }

    public static String stripColor(String input) {
        return input == null ? null : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public static String translateHexColorCodes(char altColorChar, String message) {
        Pattern hexPattern = Pattern.compile(altColorChar + "#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length());
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    public static String toLegacy(char altColorChar, String message) {
        if (message == null) {
            return null;
        }
        return ChatColor.hexToLegacy(altColorChar, message).replace('\u00a7', altColorChar);
    }

    public static String hexToLegacy(char altColorChar, String message) {
        Pattern hexPattern = Pattern.compile("\u00a7x\u00a7.\u00a7.\u00a7.\u00a7.\u00a7.\u00a7.");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length());
        while (matcher.find()) {
            String group = matcher.group(0);
            matcher.appendReplacement(buffer, altColorChar + "#" + group.charAt(3) + group.charAt(5) + group.charAt(7) + group.charAt(9) + group.charAt(11) + group.charAt(13));
        }
        return matcher.appendTail(buffer).toString();
    }

    public static String translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || ALL_CODES.indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String translateAll(char altColorChar, String textToTranslate) {
        if (textToTranslate == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes(altColorChar, ChatColor.translateHexColorCodes(altColorChar, textToTranslate));
    }

    public static ChatColor getByChar(char code) {
        return BY_CHAR.get(Character.valueOf(code));
    }

    public String getName() {
        return this.name;
    }

    public static String getLastColor(String text, char colorChar) {
        if (!text.contains("" + colorChar)) {
            return null;
        }
        String[] data = text.split("" + colorChar);
        return colorChar + data[data.length - 1].substring(0, 1);
    }

    public static String getLastFullColor(String text, char colorChar) {
        String otherColor = ChatColor.getLastColor(text, colorChar);
        if (otherColor == null) {
            return "";
        }
        ChatColor[] extra = new ChatColor[]{MAGIC, BOLD, STRIKETHROUGH, UNDERLINE, ITALIC};
        String stripped = text;
        for (ChatColor c : extra) {
            stripped = stripped.replace(c.toString(), "");
        }
        String lastColor = ChatColor.getLastColor(stripped, colorChar);
        if (!otherColor.equals(lastColor)) {
            for (ChatColor c : extra) {
                if (!otherColor.equals(c.toString())) continue;
                return otherColor + lastColor;
            }
        }
        return lastColor;
    }

    public static String highlight(String text, String toHighlight, String highlighter) {
        return ChatColor.highlight(text, toHighlight, highlighter, ChatColor.RESET.toString);
    }

    public static String highlight(String text, String toHighlight, String highlighter, String resetColor) {
        return ChatColor.highlight(text, toHighlight, highlighter, resetColor, false);
    }

    public static String highlight(String text, String toHighlight, String highlighter, String resetColor, boolean ignoreCase) {
        if (toHighlight == null || toHighlight.isEmpty() || highlighter == null || highlighter.isEmpty()) {
            return text;
        }
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(ignoreCase ? text.toLowerCase().split(toHighlight.toLowerCase(), -1) : text.split(toHighlight, -1)));
        if (ignoreCase) {
            int size = data.size();
            int index = 0;
            for (int i = 0; i < size; ++i) {
                String value = (String)data.get(i);
                if (value.isEmpty()) continue;
                StringBuilder corrected = new StringBuilder();
                for (int i1 = 0; i1 < value.length(); ++i1) {
                    int origin = index + corrected.length() + i * toHighlight.length();
                    corrected.append(text.charAt(origin));
                }
                data.set(i, corrected.toString());
                index += corrected.length();
            }
        }
        StringBuilder builder = new StringBuilder();
        String lastColor = "";
        int index = 0;
        for (int i = 0; i < data.size(); ++i) {
            String current = (String)data.get(i);
            String color = ChatColor.getLastColor(current, '\u00a7');
            if (color != null) {
                lastColor = color;
            }
            builder.append(current);
            if (i >= data.size() - 1) continue;
            StringBuilder highlight = new StringBuilder();
            for (int j = index += current.length(); j < index + toHighlight.length(); ++j) {
                highlight.append(text.charAt(j));
            }
            builder.append(highlighter).append((CharSequence)highlight).append(resetColor).append(lastColor);
            index += toHighlight.length();
        }
        return builder.toString();
    }

    static {
        ChatColor[] arr$;
        BLACK = new ChatColor('0', "black");
        DARK_BLUE = new ChatColor('1', "dark_blue");
        DARK_GREEN = new ChatColor('2', "dark_green");
        DARK_AQUA = new ChatColor('3', "dark_aqua");
        DARK_RED = new ChatColor('4', "dark_red");
        DARK_PURPLE = new ChatColor('5', "dark_purple");
        GOLD = new ChatColor('6', "gold");
        GRAY = new ChatColor('7', "gray");
        DARK_GRAY = new ChatColor('8', "dark_gray");
        BLUE = new ChatColor('9', "blue");
        GREEN = new ChatColor('a', "green");
        AQUA = new ChatColor('b', "aqua");
        RED = new ChatColor('c', "red");
        LIGHT_PURPLE = new ChatColor('d', "light_purple");
        YELLOW = new ChatColor('e', "yellow");
        WHITE = new ChatColor('f', "white");
        MAGIC = new ChatColor('k', "obfuscated");
        BOLD = new ChatColor('l', "bold");
        STRIKETHROUGH = new ChatColor('m', "strikethrough");
        UNDERLINE = new ChatColor('n', "underline");
        ITALIC = new ChatColor('o', "italic");
        RESET = new ChatColor('r', "reset");
        $VALUES = new ChatColor[]{BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE, MAGIC, BOLD, STRIKETHROUGH, UNDERLINE, ITALIC, RESET};
        STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[x0-9A-FK-OR]");
        BY_CHAR = new HashMap<Character, ChatColor>();
        for (ChatColor colour : arr$ = ChatColor.values()) {
            BY_CHAR.put(Character.valueOf(colour.code), colour);
        }
    }
}

