/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.nbt.specific;

import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.tools.nbt.NBTTagCompound;

public class BlockEntityNBTTagCompound
extends NBTTagCompound {
    private static final Class<?> CRAFT_BLOCK_ENTITY_STATE = IReflection.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "block.CraftBlockEntityState");
    private static final IReflection.FieldAccessor<?> TILE_ENTITY;
    private static final IReflection.MethodAccessor SAVE;
    private Object entity;
    private Object tile;

    public BlockEntityNBTTagCompound() {
    }

    public BlockEntityNBTTagCompound(Object entity) {
        if (!CRAFT_BLOCK_ENTITY_STATE.isInstance(entity)) {
            throw new IllegalArgumentException(entity.getClass() + " cannot be cast to " + CRAFT_BLOCK_ENTITY_STATE);
        }
        this.entity = entity;
        this.tile = TILE_ENTITY.get(entity);
        this.tag = this.create();
        this.save(this.tag);
    }

    public Object save(Object nbtTag) {
        return SAVE.invoke(this.tile, nbtTag);
    }

    public Object getEntity() {
        return this.entity;
    }

    public Object getTile() {
        return this.tile;
    }

    static {
        Class<?> tileClass = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.level.block.entity"), "TileEntity");
        TILE_ENTITY = IReflection.getField(CRAFT_BLOCK_ENTITY_STATE, "tileEntity");
        SAVE = IReflection.getMethod(tileClass, "save", PacketUtils.NBTTagCompoundClass, new Class[]{PacketUtils.NBTTagCompoundClass});
    }
}

