/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.nbt;

import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.nbt.NBTBase;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;

public class NBTTagCompound {
    protected static Class<?> TAG = IReflection.getClass(IReflection.ServerPacket.NBT, "NBTBase");
    protected static IReflection.MethodAccessor SET;
    protected static IReflection.MethodAccessor GET;
    protected static Function<Object, Object> TAG_FIELD_GET;
    protected static BiConsumer<Object, Object> TAG_FIELD_SET;
    protected static IReflection.FieldAccessor<?> MAP_FIELD;
    protected static IReflection.MethodAccessor asBukkitCopy;
    protected Object tag;
    private Object itemStack;

    public NBTTagCompound(ItemStack item) {
        this.itemStack = PacketUtils.getItemStack(item);
        if (this.itemStack == null) {
            return;
        }
        this.tag = TAG_FIELD_GET.apply(this.itemStack);
        if (this.tag == null) {
            this.tag = this.create();
            TAG_FIELD_SET.accept(this.itemStack, this.tag);
        }
    }

    @NmsLoader
    public NBTTagCompound() {
        this.tag = this.create();
    }

    public NBTTagCompound(Object tag) {
        this.tag = tag;
    }

    public ItemStack getItem() {
        return this.itemStack == null ? null : (ItemStack)asBukkitCopy.invoke(null, this.itemStack);
    }

    public Object getTag() {
        return this.tag;
    }

    public Object set(String key, NBTBase<?> value) {
        if (this.tag == null) {
            return null;
        }
        Object instance = value.invoke();
        if (instance == null) {
            return null;
        }
        return SET.invoke(this.tag, key, instance);
    }

    public Object get(String key) {
        if (this.tag == null) {
            return null;
        }
        return GET.invoke(this.tag, key);
    }

    public Map<String, Object> getMap() {
        return (Map)MAP_FIELD.get(this.tag);
    }

    public NBTTagCompound setNBT(NBTTagCompound nbtTagCompound) {
        this.tag = nbtTagCompound;
        return this;
    }

    protected Object create() {
        return IReflection.getConstructor(PacketUtils.NBTTagCompoundClass, new Class[0]).newInstance(new Object[0]);
    }

    static {
        if (Version.atLeast(20.5)) {
            SET = IReflection.getMethod(PacketUtils.NBTTagCompoundClass, TAG, new Class[]{String.class, TAG});
            GET = IReflection.getMethod(PacketUtils.NBTTagCompoundClass, TAG, new Class[]{String.class});
            Class<?> customDataClass = IReflection.getClass("net.minecraft.world.item.component.", "CustomData");
            Class<?> typeClass = IReflection.getClass(IReflection.ServerPacket.COMPONENT, "DataComponentType");
            Class<?> typesClass = IReflection.getClass(IReflection.ServerPacket.COMPONENT, "DataComponents");
            Object customDataType = IReflection.getField(typesClass, "CUSTOM_DATA").get(null);
            Object blockEntityDataType = IReflection.getField(typesClass, "BLOCK_ENTITY_DATA").get(null);
            IReflection.MethodAccessor getMethod = IReflection.getMethod(PacketUtils.ItemStackClass, Object.class, new Class[]{typeClass});
            IReflection.MethodAccessor copyTag = IReflection.getMethod(customDataClass, PacketUtils.NBTTagCompoundClass, new Class[0]);
            TAG_FIELD_GET = itemStack -> {
                Object customData = getMethod.invoke(itemStack, customDataType);
                if (customData == null) {
                    return null;
                }
                return copyTag.invoke(customData, new Object[0]);
            };
            IReflection.ConstructorAccessor newCustomData = IReflection.getConstructor(customDataClass, PacketUtils.NBTTagCompoundClass);
            if (newCustomData == null) {
                throw new IllegalStateException("Cannot find custom data constructor!");
            }
            IReflection.MethodAccessor setMethod = IReflection.getMethod(PacketUtils.ItemStackClass, (Class)null, new Class[]{typeClass, Object.class});
            TAG_FIELD_SET = (itemStack, tag) -> {
                Object customData = newCustomData.newInstance(tag);
                setMethod.invoke(itemStack, customDataType, customData);
            };
        } else {
            IReflection.FieldAccessor<?> tagField = IReflection.getField(PacketUtils.ItemStackClass, PacketUtils.NBTTagCompoundClass, 0);
            TAG_FIELD_GET = tagField::get;
            TAG_FIELD_SET = tagField::set;
            if (Version.atLeast(18.0)) {
                SET = IReflection.getMethod(PacketUtils.NBTTagCompoundClass, "a", TAG, new Class[]{String.class, TAG});
                GET = IReflection.getMethod(PacketUtils.NBTTagCompoundClass, "c", TAG, new Class[]{String.class});
            } else {
                SET = Version.atLeast(14.0) ? IReflection.getMethod(PacketUtils.NBTTagCompoundClass, "set", TAG, new Class[]{String.class, TAG}) : IReflection.getMethod(PacketUtils.NBTTagCompoundClass, "set", new Class[]{String.class, TAG});
                GET = IReflection.getMethod(PacketUtils.NBTTagCompoundClass, "get", TAG, new Class[]{String.class});
            }
        }
        MAP_FIELD = IReflection.getField(PacketUtils.NBTTagCompoundClass, Map.class, 0);
        asBukkitCopy = IReflection.getMethod(PacketUtils.CraftItemStackClass, "asBukkitCopy", ItemStack.class, new Class[]{PacketUtils.ItemStackClass});
    }
}

