/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.items.expansions;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BannerValue {
    private static boolean available;

    @Nullable
    public static List<Map<String, Object>> serialize(@NotNull ItemMeta itemMeta) {
        if (!available || !(itemMeta instanceof BannerMeta)) {
            return null;
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        BannerMeta meta = (BannerMeta)itemMeta;
        for (Pattern pattern : meta.getPatterns()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("color", pattern.getColor().name());
            map.put("pattern", pattern.getPattern().getIdentifier());
            data.add(map);
        }
        return data;
    }

    public static void apply(ItemMeta itemMeta, List<Map<String, Object>> data) {
        if (!available || !(itemMeta instanceof BannerMeta)) {
            return;
        }
        BannerMeta meta = (BannerMeta)itemMeta;
        for (Map<String, Object> map : data) {
            try {
                DyeColor dyeColor = DyeColor.valueOf((String)((String)map.get("color")));
                PatternType pattern = PatternType.getByIdentifier((String)((String)map.get("pattern")));
                if (pattern == null) continue;
                meta.addPattern(new Pattern(dyeColor, pattern));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    static {
        try {
            Class.forName("org.bukkit.inventory.meta.BannerMeta");
            available = true;
        }
        catch (ClassNotFoundException e) {
            available = false;
        }
    }
}

