/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.items;

import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemHelper {
    public static int getDurability(@NotNull ItemStack itemStack) {
        if (Version.atLeast(13.0)) {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof Damageable) {
                return ((Damageable)meta).getDamage();
            }
            return 0;
        }
        return itemStack.getDurability();
    }

    public static void setDurability(@NotNull ItemStack itemStack, int damage) {
        if (Version.atLeast(13.0)) {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(damage);
            }
        } else {
            itemStack.setDurability((short)damage);
        }
    }

    public static byte getData(@NotNull ItemStack itemStack) {
        if (Version.before(13.0) && itemStack.getData() != null) {
            return itemStack.getData().getData();
        }
        return 0;
    }

    public static void setData(@NotNull ItemStack itemStack, byte data) {
        if (Version.before(13.0) && itemStack.getData() != null) {
            itemStack.getData().setData(data);
        }
    }
}

