/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.items;

import com.mojang.authlib.GameProfile;
import de.codingair.tradesystem.lib.codingapi.player.data.GameProfileUtils;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.Skull;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PotionData;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONObject;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONParser;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.ParseException;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.DataMask;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemHelper;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.codingapi.tools.items.expansions.BannerValue;
import de.codingair.tradesystem.lib.codingapi.tools.items.expansions.DamageableValue;
import de.codingair.tradesystem.lib.codingapi.tools.nbt.NBTTagCompound;
import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.codingapi.utils.TextAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.Potion;

public class ItemBuilder
implements Serializable {
    private String name = "";
    private Material type = null;
    private byte data = 0;
    private int durability = 0;
    private int damage = 0;
    private int amount = 1;
    private DyeColor color = null;
    private ItemMeta preMeta = null;
    private PotionData potionData = null;
    private NBTTagCompound nbt = null;
    private int customModel = 0;
    private List<Map<String, Object>> banner = null;
    private String skullId = null;
    private List<String> lore = null;
    private HashMap<Enchantment, Integer> enchantments = null;
    private boolean hideStandardLore = false;
    private boolean hideEnchantments = false;
    private boolean hideName = false;
    private boolean unbreakable = false;

    public ItemBuilder() {
    }

    public ItemBuilder(String skullId) {
        this(XMaterial.PLAYER_HEAD);
        this.setSkullId(skullId);
    }

    public ItemBuilder(XMaterial xMaterial) {
        this(xMaterial.parseItem());
    }

    public ItemBuilder(Material type) {
        if (type == null) {
            type = Material.STONE;
        }
        this.type = type;
    }

    public ItemBuilder(ItemStack item) {
        if (item == null) {
            return;
        }
        this.nbt = new NBTTagCompound(item);
        this.type = item.getType();
        this.data = ItemHelper.getData(item);
        this.durability = ItemHelper.getDurability(item);
        this.amount = item.getAmount();
        if (item.getEnchantments().size() > 0) {
            this.enchantments = new HashMap();
            this.enchantments.putAll(item.getEnchantments());
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            this.preMeta = item.getItemMeta();
            this.name = meta.getDisplayName();
            if (Version.get().isBiggerThan(12.0)) {
                this.damage = DamageableValue.getDamage(this.preMeta);
            }
            if (Version.get().isBiggerThan(Version.v1_11)) {
                this.unbreakable = this.preMeta.isUnbreakable();
            }
            if (Version.get().isBiggerThan(Version.v1_13)) {
                assert (PacketUtils.hasCustomModelData != null);
                if (((Boolean)PacketUtils.hasCustomModelData.invoke(this.preMeta, new Object[0])).booleanValue()) {
                    assert (PacketUtils.getCustomModelData != null);
                    this.customModel = (Integer)PacketUtils.getCustomModelData.invoke(this.preMeta, new Object[0]);
                }
            }
            if (this.enchantments == null) {
                this.enchantments = new HashMap();
            }
            this.enchantments.putAll(item.getItemMeta().getEnchants());
            item.getItemMeta().getEnchants().forEach((ench, level) -> this.preMeta.removeEnchant(ench));
            try {
                LeatherArmorMeta leatherMeta = (LeatherArmorMeta)item.getItemMeta();
                this.color = DyeColor.getByColor((Color)leatherMeta.getColor());
            }
            catch (Exception leatherMeta) {
                // empty catch block
            }
            if (item.getItemMeta().hasLore()) {
                this.lore = new ArrayList<String>();
                if (meta.getLore() != null) {
                    this.lore.addAll(meta.getLore());
                }
            }
            this.hideEnchantments = item.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS);
            boolean bl = this.hideStandardLore = item.getItemMeta().getItemFlags().size() == 1 && !item.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS) || item.getItemMeta().getItemFlags().size() > 1;
            if ("\u00a70".equals(item.getItemMeta().getDisplayName())) {
                this.hideName = true;
                this.name = null;
            }
            try {
                IReflection.FieldAccessor profile = IReflection.getField(meta.getClass(), "profile");
                this.skullId = GameProfileUtils.extractSkinId((GameProfile)profile.get(meta));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.banner = BannerValue.serialize(item.getItemMeta());
        }
        if (item.getType().name().toUpperCase().contains("POTION")) {
            this.potionData = new PotionData(item);
        }
    }

    public ItemBuilder(Material type, ItemMeta itemMeta) {
        this(type);
        this.preMeta = itemMeta;
    }

    public ItemBuilder(ItemStack item, ItemMeta itemMeta) {
        this(item);
        this.preMeta = itemMeta;
    }

    public ItemBuilder(GameProfile profile) {
        this(ItemBuilder.getHead(profile));
    }

    public ItemBuilder(Player player) {
        this(GameProfileUtils.getGameProfile(player));
    }

    public ItemBuilder(Skull skull) {
        this(skull.getItemStack(), skull.getItemMeta());
    }

    public static ItemBuilder getFromJSON(String data) {
        JSONParser parser = new JSONParser();
        try {
            JSON jsonObject = new JSON((Map)((JSONObject)parser.parse(data)));
            return ItemBuilder.getFromJSON(jsonObject);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new ItemBuilder(Material.AIR);
        }
    }

    public static ItemBuilder getFromJSON(JSON jsonObject) {
        if (jsonObject == null) {
            return new ItemBuilder(Material.AIR);
        }
        ItemBuilder builder = new ItemBuilder();
        try {
            builder.read(jsonObject);
            return builder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ItemBuilder(XMaterial.AIR);
        }
    }

    public static ItemBuilder getFromBase64String(String code) {
        if (code == null) {
            return null;
        }
        return ItemBuilder.getFromJSON(new String(Base64.getDecoder().decode(code.getBytes())));
    }

    public static ItemStack getHead(GameProfile gameProfile) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        ItemStack item = new ItemStack(head == null ? Material.STONE : head.getType(), 1, 3);
        if (gameProfile == null) {
            return item;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            ItemBuilder.applyGameProfile((ItemMeta)meta, gameProfile);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    private static void applyGameProfile(ItemMeta meta, GameProfile gameProfile) {
        try {
            IReflection.MethodAccessor setProfile = IReflection.getMethod(meta.getClass(), GameProfile.class);
            setProfile.invoke(meta, gameProfile);
        }
        catch (Throwable t) {
            try {
                IReflection.FieldAccessor profile = IReflection.getField(meta.getClass(), "profile");
                profile.set(meta, gameProfile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ItemStack getItem() {
        PotionMeta meta;
        if (this.type == null) {
            return null;
        }
        ItemStack item = new ItemStack(this.type);
        if (this.type.name().contains("POTION")) {
            meta = (PotionMeta)item.getItemMeta();
            if (this.potionData != null) {
                if (Version.get().isBiggerThan(Version.v1_8) && this.potionData.isCorrect()) {
                    meta = this.potionData.getMeta();
                } else if (!Version.get().isBiggerThan(Version.v1_8) && this.potionData.isCorrect()) {
                    Potion potion = this.potionData.getPotion();
                    if (meta != null && potion.getType().getEffectType() != null) {
                        meta.setMainEffect(potion.getType().getEffectType());
                    }
                }
            }
            item.setItemMeta((ItemMeta)meta);
        }
        if ((this.type.name().contains("SKULL") || this.type.name().contains("HEAD")) && this.data == 3) {
            item = new ItemStack(this.type, 1, 3);
        }
        item.setAmount(this.amount);
        ItemMeta itemMeta = meta = this.preMeta == null ? item.getItemMeta() : this.preMeta;
        if (meta != null) {
            meta.setDisplayName(this.name);
            meta.setLore(this.lore);
            if (this.isColorable() && this.color != null) {
                if (meta instanceof LeatherArmorMeta) {
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                    leatherArmorMeta.setColor(this.color.getColor());
                } else {
                    this.data = this.type.name().equals("INK_SACK") ? this.color.getDyeData() : this.color.getWoolData();
                    ItemHelper.setDurability(item, this.data);
                }
            } else {
                if (this.data != 0 && Version.before(13.0)) {
                    ItemFlag[] data = new MaterialData(this.type, this.data);
                    item.setData((MaterialData)data);
                }
                ItemHelper.setDurability(item, this.durability);
            }
            if (this.hideName || this.name == null) {
                meta.setDisplayName("\u00a70");
            }
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (this.hideStandardLore) {
                for (ItemFlag itemFlag : ItemFlag.values()) {
                    if (itemFlag.equals((Object)ItemFlag.HIDE_ENCHANTS)) continue;
                    meta.addItemFlags(new ItemFlag[]{itemFlag});
                }
            }
            if (this.skullId != null) {
                GameProfile gameProfile = GameProfileUtils.createBySkinId(this.skullId);
                ItemBuilder.applyGameProfile((ItemMeta)meta, gameProfile);
            }
            if (Version.get().isBiggerThan(Version.v1_11)) {
                meta.setUnbreakable(this.unbreakable);
            }
            if (Version.get().isBiggerThan(Version.v1_13)) {
                assert (PacketUtils.setCustomModelData != null);
                PacketUtils.setCustomModelData.invoke(meta, this.customModel);
            }
            if (Version.get().isBiggerThan(12.0)) {
                DamageableValue.setDamage((ItemMeta)meta, this.damage);
            }
            if (this.banner != null) {
                BannerValue.apply((ItemMeta)meta, this.banner);
            }
            item.setItemMeta((ItemMeta)meta);
        }
        if (this.enchantments != null) {
            item.addUnsafeEnchantments(this.enchantments);
        }
        if (this.nbt != null) {
            return new NBTTagCompound(item).setNBT(this.nbt).getItem();
        }
        return item;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean read(DataMask d) throws Exception {
        try {
            var2_2 = d.keySet(false).iterator();
            block44: while (var2_2.hasNext()) {
                var4_5 = keyName = var2_2.next();
                var5_6 = -1;
                switch (var4_5.hashCode()) {
                    case 2374422: {
                        if (!var4_5.equals("Lore")) break;
                        var5_6 = 0;
                        break;
                    }
                    case 65290051: {
                        if (!var4_5.equals("Color")) break;
                        var5_6 = 1;
                        break;
                    }
                    case -1531220420: {
                        if (!var4_5.equals("Enchantments")) break;
                        var5_6 = 2;
                        break;
                    }
                    case 2420395: {
                        if (!var4_5.equals("Name")) break;
                        var5_6 = 3;
                        break;
                    }
                    case 682526717: {
                        if (!var4_5.equals("PotionData")) break;
                        var5_6 = 4;
                        break;
                    }
                    case 2622298: {
                        if (!var4_5.equals("Type")) break;
                        var5_6 = 5;
                        break;
                    }
                    case 2122698: {
                        if (!var4_5.equals("Data")) break;
                        var5_6 = 6;
                        break;
                    }
                    case -1585416151: {
                        if (!var4_5.equals("Durability")) break;
                        var5_6 = 7;
                        break;
                    }
                    case 1964981368: {
                        if (!var4_5.equals("Amount")) break;
                        var5_6 = 8;
                        break;
                    }
                    case 1127110101: {
                        if (!var4_5.equals("HideStandardLore")) break;
                        var5_6 = 9;
                        break;
                    }
                    case 1158986910: {
                        if (!var4_5.equals("HideEnchantments")) break;
                        var5_6 = 10;
                        break;
                    }
                    case -161264576: {
                        if (!var4_5.equals("Unbreakable")) break;
                        var5_6 = 11;
                        break;
                    }
                    case -1709457651: {
                        if (!var4_5.equals("HideName")) break;
                        var5_6 = 12;
                        break;
                    }
                    case -1269761674: {
                        if (!var4_5.equals("SkullOwner")) break;
                        var5_6 = 13;
                        break;
                    }
                    case -126441960: {
                        if (!var4_5.equals("CustomModel")) break;
                        var5_6 = 14;
                        break;
                    }
                    case 2039707535: {
                        if (!var4_5.equals("Damage")) break;
                        var5_6 = 15;
                        break;
                    }
                    case 1982491468: {
                        if (!var4_5.equals("Banner")) break;
                        var5_6 = 16;
                    }
                }
                switch (var5_6) {
                    case 0: {
                        jsonLore = d.getList("Lore");
                        if (jsonLore == null) break;
                        lore = new ArrayList<String>();
                        for (E value : jsonLore) {
                            v = (String)value;
                            lore.add(v == null ? null : ChatColor.translateAlternateColorCodes('&', v));
                        }
                        this.setLore(lore);
                        break;
                    }
                    case 1: {
                        jsonColor = (JSON)d.get("Color");
                        if (jsonColor == null) break;
                        red = Integer.parseInt(jsonColor.get("Red") + "");
                        green = Integer.parseInt(jsonColor.get("Green") + "");
                        blue = Integer.parseInt(jsonColor.get("Blue") + "");
                        this.setColor(DyeColor.getByColor((Color)Color.fromRGB((int)red, (int)green, (int)blue)));
                        break;
                    }
                    case 2: {
                        jsonEnchantments = (JSON)d.get("Enchantments");
                        if (jsonEnchantments == null) break;
                        for (String name : jsonEnchantments.keySet(false)) {
                            enchantment = Enchantment.getByName((String)name);
                            level = Integer.parseInt(jsonEnchantments.get(name) + "");
                            this.addEnchantment(enchantment, level);
                        }
                        continue block44;
                    }
                    case 3: {
                        name = (String)d.get("Name");
                        if (name == null) break;
                        this.setName(ChatColor.translateAlternateColorCodes('&', name));
                        break;
                    }
                    case 4: {
                        obj = d.getRaw("PotionData");
                        if (obj == null) break;
                        data = PotionData.fromJSONString((String)obj);
                        this.setPotionData(data);
                        break;
                    }
                    case 5: {
                        obj = d.get("Type");
                        if (obj == null) break;
                        name = (String)d.get("Type");
                        material = null;
                        try {
                            material = Material.valueOf((String)name);
                        }
                        catch (IllegalArgumentException ex) {
                            if (!Version.get().isBiggerThan(Version.v1_12)) ** GOTO lbl138
                            obj = d.get("Data");
                            data = 0;
                            if (obj != null) {
                                data = Byte.parseByte(d.get("Data") + "");
                            }
                            if ((mat = XMaterial.matchDefinedXMaterial(name, data)).isPresent()) {
                                item = mat.get().parseItem();
                                if (item != null) {
                                    material = item.getType();
                                }
                            } else {
                                throw new IllegalAccessException("Couldn't find material (" + name + ", " + data + ")!");
lbl138:
                                // 1 sources

                                mat = XMaterial.matchDefinedXMaterial(name, this.data);
                                if (mat.isPresent() && (item = (m = mat.get()).parseItem()) != null) {
                                    material = item.getType();
                                    this.setData(m.getData());
                                }
                            }
                            try {
                                material = Material.valueOf((String)name);
                            }
                            catch (IllegalArgumentException ex2) {
                                if (!name.equalsIgnoreCase("SPLASH_POTION")) ** GOTO lbl149
                                material = Material.POTION;
                            }
                        }
lbl149:
                        // 4 sources

                        this.setType(material);
                        break;
                    }
                    case 6: {
                        obj = d.get("Data");
                        if (obj == null || this.getData() == 0) break;
                        this.setData(Byte.parseByte(d.get("Data") + ""));
                        break;
                    }
                    case 7: {
                        obj = d.get("Durability");
                        if (obj == null) break;
                        this.setDurability(Short.parseShort(d.get("Durability") + ""));
                        break;
                    }
                    case 8: {
                        amount = (Integer)d.get("Amount");
                        if (amount == null) break;
                        this.setAmount(amount);
                        break;
                    }
                    case 9: {
                        obj = d.get("HideStandardLore");
                        if (obj == null) break;
                        this.setHideStandardLore((Boolean)d.get("HideStandardLore"));
                        break;
                    }
                    case 10: {
                        obj = d.get("HideEnchantments");
                        if (obj == null) break;
                        this.setHideEnchantments((Boolean)d.get("HideEnchantments"));
                        break;
                    }
                    case 11: {
                        obj = d.get("Unbreakable");
                        if (obj == null) break;
                        this.setUnbreakable((Boolean)d.get("Unbreakable"));
                        break;
                    }
                    case 12: {
                        obj = d.get("HideName");
                        if (obj == null) break;
                        this.setHideName((Boolean)d.get("HideName"));
                        break;
                    }
                    case 13: {
                        data = (String)d.getRaw("SkullOwner");
                        if (data == null) break;
                        if (data.contains("Property_Signature")) {
                            this.setSkullId(GameProfileUtils.extractSkinId(GameProfileUtils.gameProfileFromJSON((String)data)));
                            break;
                        }
                        this.setSkullId((String)d.get("SkullOwner"));
                        break;
                    }
                    case 14: {
                        this.setCustomModel(d.getInteger("CustomModel"));
                        break;
                    }
                    case 15: {
                        this.setDamage(d.getInteger("Damage"));
                        break;
                    }
                    case 16: {
                        data = new ArrayList<E>();
                        l = d.getList("Banner");
                        for (E o : l) {
                            if (!(o instanceof Map)) continue;
                            data.add((Map)o);
                        }
                        if (data.isEmpty()) break;
                        this.banner = data;
                        break;
                    }
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void write(DataMask d) {
        JSON color = new JSON();
        JSON enchantments = new JSON();
        JSONArray lore = new JSONArray();
        if (this.enchantments != null) {
            for (Enchantment ench : this.enchantments.keySet()) {
                enchantments.put(ench.getName(), this.enchantments.get(ench));
            }
        }
        if (this.lore != null) {
            for (String s : this.lore) {
                lore.add(s.replace("\u00a7", "&"));
            }
        }
        if (this.color != null) {
            color.put("Red", this.color.getColor().getRed());
            color.put("Green", this.color.getColor().getGreen());
            color.put("Blue", this.color.getColor().getBlue());
        }
        if (this.name != null) {
            d.put("Name", this.name.replace("\u00a7", "&"));
        }
        if (this.type != null) {
            d.put("Type", this.type.name());
        }
        d.put("Data", this.data);
        d.put("Durability", this.durability);
        d.put("Amount", this.amount);
        if (this.lore != null) {
            d.put("Lore", lore.isEmpty() ? null : lore);
        }
        if (this.color != null) {
            d.put("Color", color.isEmpty() ? null : color.toJSONString());
        }
        if (this.enchantments != null) {
            d.put("Enchantments", enchantments.isEmpty() ? null : enchantments.toJSONString());
        }
        d.put("HideStandardLore", this.hideStandardLore);
        d.put("HideEnchantments", this.hideEnchantments);
        d.put("Unbreakable", this.unbreakable);
        d.put("HideName", this.hideName);
        d.put("PotionData", this.potionData == null ? null : this.potionData.toJSONString());
        d.put("SkullOwner", this.skullId);
        d.put("CustomModel", this.customModel);
        d.put("Damage", this.damage);
        d.put("Banner", this.banner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemBuilder builder = (ItemBuilder)o;
        return this.data == builder.data && this.durability == builder.durability && this.amount == builder.amount && this.customModel == builder.customModel && this.hideStandardLore == builder.hideStandardLore && this.hideEnchantments == builder.hideEnchantments && this.hideName == builder.hideName && this.damage == builder.damage && this.unbreakable == builder.unbreakable && Objects.equals(this.name, builder.name) && this.type == builder.type && this.color == builder.color && Objects.equals(this.preMeta, builder.preMeta) && Objects.equals(this.potionData, builder.potionData) && Objects.equals(this.nbt, builder.nbt) && Objects.equals(this.skullId, builder.skullId) && Objects.equals(this.lore, builder.lore) && Objects.equals(this.banner, builder.banner) && Objects.equals(this.enchantments, builder.enchantments);
    }

    public boolean equalsSimply(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemBuilder builder = (ItemBuilder)o;
        return this.data == builder.data && this.durability == builder.durability && this.amount == builder.amount && this.type == builder.type && Objects.equals(this.skullId, builder.skullId) && Objects.equals(this.lore, builder.lore);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.data, this.durability, this.amount, this.color, this.preMeta, this.potionData, this.nbt, this.customModel, this.skullId, this.lore, this.enchantments, this.hideStandardLore, this.hideEnchantments, this.hideName, this.unbreakable, this.damage);
    }

    @Override
    public void destroy() {
    }

    public String toJSONString() {
        JSON jsonObject = new JSON();
        this.write(jsonObject);
        return jsonObject.toJSONString();
    }

    public ItemBuilder reset(boolean onlyAppearance) {
        if (onlyAppearance) {
            this.setHideName(false);
            this.setHideEnchantments(false);
            this.setHideStandardLore(false);
        } else {
            this.name = null;
            this.data = 0;
            this.amount = 1;
            this.color = null;
            this.lore = null;
            this.enchantments = null;
            this.hideStandardLore = true;
            this.hideEnchantments = true;
            this.hideName = true;
        }
        return this;
    }

    public boolean isColorable() {
        switch (this.type.name()) {
            case "INK_SACK": 
            case "CARPET": 
            case "WOOL": 
            case "STAINED_GLASS": 
            case "STAINED_CLAY": 
            case "STAINED_GLASS_PANE": 
            case "LEATHER_HELMET": 
            case "LEATHER_CHESTPLATE": 
            case "LEATHER_LEGGINGS": 
            case "LEATHER_BOOTS": {
                return true;
            }
        }
        return false;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public ItemBuilder setColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ItemBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder checkFirstLine() {
        if (this.name == null && this.lore != null && !this.lore.isEmpty()) {
            this.setName(this.lore.remove(0));
        }
        this.setHideName(this.name == null);
        return this;
    }

    public ItemBuilder setText(String text, int wordWrap) {
        return this.setText(text, TextAlignment.LEFT, wordWrap);
    }

    public ItemBuilder setText(String text, TextAlignment alignment, int wordWrap) {
        List<String> list = TextAlignment.lineBreak(text, wordWrap);
        if (list.isEmpty()) {
            return this;
        }
        if (alignment != null) {
            list = alignment.apply(list);
        }
        this.setName(list.remove(0));
        this.setLore(list);
        return this;
    }

    public ItemBuilder setText(String ... text) {
        return this.setText(new ArrayList<String>(Arrays.asList(text)));
    }

    public ItemBuilder setText(List<String> text) {
        this.setName(null);
        this.removeLore();
        if (text.isEmpty()) {
            return this;
        }
        this.setName(text.remove(0));
        if (!text.isEmpty()) {
            this.setLore(text);
        }
        return this;
    }

    public ItemBuilder addText(String ... text) {
        return this.addText(Arrays.asList(text));
    }

    public ItemBuilder addText(String text, int wordWrap) {
        List<String> list = TextAlignment.lineBreak(text, wordWrap);
        if (list.isEmpty()) {
            return this;
        }
        if (this.name == null || this.name.isEmpty()) {
            this.setName(list.remove(0));
            if (this.name != null && !this.name.isEmpty()) {
                this.setHideName(false);
            }
        }
        this.addLore(list);
        return this;
    }

    public ItemBuilder addText(List<String> text) {
        if (text.isEmpty()) {
            return this;
        }
        text = new ArrayList<String>(text);
        if (this.name == null || this.name.isEmpty()) {
            this.name = text.remove(0);
            if (this.name != null && !this.name.isEmpty()) {
                this.setHideName(false);
            }
        }
        this.addLore(text);
        return this;
    }

    public ItemBuilder removeText(List<String> text) {
        if (text.isEmpty()) {
            return this;
        }
        for (String s : text) {
            if (this.name != null && this.name.equals(s)) {
                this.name = null;
            }
            this.lore.removeAll(text);
        }
        return this;
    }

    public Material getType() {
        return this.type;
    }

    public ItemBuilder setType(XMaterial type) {
        ItemStack item = type.parseItem();
        if (item != null) {
            this.setType(item.getType());
            this.setData(type.getData());
        } else {
            this.setType(Material.STONE);
        }
        return this;
    }

    public ItemBuilder setType(Material type) {
        this.type = type;
        return this;
    }

    public byte getData() {
        return this.data;
    }

    public ItemBuilder setData(byte data) {
        XMaterial m;
        this.data = data;
        if (this.getType() != null && ((m = XMaterial.matchXMaterial(this.getType())) == XMaterial.POTION || m == XMaterial.PLAYER_HEAD)) {
            this.setDurability(this.getData());
        }
        return this;
    }

    public int getDamage() {
        return this.damage;
    }

    public ItemBuilder setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public ItemBuilder setDurability(int durability) {
        this.durability = durability;
        return this;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ItemBuilder setLore(List<String> lore) {
        if (this.lore != null) {
            this.lore.clear();
        }
        return this.addLore(lore);
    }

    public ItemBuilder setLore(String ... lore) {
        return this.setLore(Arrays.asList(lore));
    }

    public ItemBuilder addLore(List<String> lore) {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        return this.addLore(this.lore.size(), lore);
    }

    public ItemBuilder addLore(String ... lore) {
        return this.addLore(Arrays.asList(lore));
    }

    public ItemBuilder addLore(int index, String ... lore) {
        return this.addLore(index, Arrays.asList(lore));
    }

    public ItemBuilder addLore(int index, List<String> lore) {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        if (lore == null) {
            return this;
        }
        for (String s : lore) {
            if (s == null) continue;
            if (s.contains("\n")) {
                String lastColor = "";
                for (String s1 : s.split("\n")) {
                    this.lore.add(index++, lastColor + s1);
                    lastColor = ChatColor.getLastFullColor(s1, '\u00a7');
                }
                continue;
            }
            this.lore.add(index++, s);
        }
        return this;
    }

    public ItemBuilder removeLore(List<String> lore) {
        if (this.lore == null) {
            return this;
        }
        this.lore.removeAll(lore);
        return this;
    }

    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public ItemBuilder setEnchantments(HashMap<Enchantment, Integer> enchantments) {
        if (this.enchantments != null) {
            this.enchantments.clear();
        }
        this.enchantments = enchantments;
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap();
        }
        this.enchantments.remove(enchantment);
        this.enchantments.put(enchantment, level);
        return this;
    }

    public boolean isHideStandardLore() {
        return this.hideStandardLore;
    }

    public ItemBuilder setHideStandardLore(boolean hideStandardLore) {
        this.hideStandardLore = hideStandardLore;
        return this;
    }

    public boolean isHideEnchantments() {
        return this.hideEnchantments;
    }

    public ItemBuilder setHideEnchantments(boolean hideEnchantments) {
        this.hideEnchantments = hideEnchantments;
        return this;
    }

    public boolean isHideName() {
        return this.hideName;
    }

    public ItemBuilder setHideName(boolean hideName) {
        this.hideName = hideName;
        return this;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemBuilder removeLore() {
        this.lore = null;
        return this;
    }

    public ItemBuilder removeLore(int includingStart, int excludingEnd) {
        if (excludingEnd > includingStart) {
            this.lore.subList(includingStart, excludingEnd).clear();
        }
        return this;
    }

    public ItemBuilder removeEnchantments() {
        this.enchantments = null;
        return this;
    }

    public PotionData getPotionData() {
        return this.potionData;
    }

    public void setPotionData(PotionData potionData) {
        this.potionData = potionData;
    }

    public ItemBuilder clone() {
        ItemBuilder clone = new ItemBuilder();
        clone.name = this.name;
        clone.type = this.type;
        clone.data = this.data;
        clone.durability = this.durability;
        clone.damage = this.damage;
        clone.amount = this.amount;
        clone.color = this.color;
        clone.preMeta = this.preMeta;
        clone.potionData = this.potionData;
        clone.nbt = this.nbt;
        clone.customModel = this.customModel;
        clone.banner = this.banner;
        clone.skullId = this.skullId;
        clone.lore = this.lore == null ? null : new ArrayList<String>(this.lore);
        clone.enchantments = this.enchantments == null ? null : new HashMap<Enchantment, Integer>(this.enchantments);
        clone.hideStandardLore = this.hideStandardLore;
        clone.hideEnchantments = this.hideEnchantments;
        clone.hideName = this.hideName;
        clone.unbreakable = this.unbreakable;
        return clone;
    }

    public String getSkullId() {
        return this.skullId;
    }

    public ItemBuilder setSkullId(String skullId) {
        this.skullId = skullId;
        return this;
    }

    public ItemBuilder setSkullId(Player player) {
        this.skullId = GameProfileUtils.extractSkinId(GameProfileUtils.getGameProfile(player));
        return this;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public int getCustomModel() {
        return this.customModel;
    }

    public ItemBuilder setCustomModel(int customModel) {
        this.customModel = customModel;
        return this;
    }

    public NBTTagCompound getNbt() {
        return this.nbt;
    }
}

