/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.io.utils;

import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public interface DataMask {
    default public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        if (value.getClass().isEnum()) {
            value = value.toString();
        } else {
            if (value instanceof Number && ((Number)value).doubleValue() == 0.0) {
                return this.remove(key);
            }
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return this.remove(key);
            }
            if (value.getClass().isArray() && Array.getLength(value) == 0) {
                return this.remove(key);
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                return this.remove(key);
            }
        }
        if (value instanceof Date) {
            value = ((Date)value).getTime();
        }
        return this.finalCommit(key, value);
    }

    default public <T> T getLocation(String key) {
        throw new IllegalStateException("Only for spigot purpose! (SpigotDataWriter)");
    }

    default public <T> T getItemBuilder(String key) {
        throw new IllegalStateException("Only for spigot purpose! (SpigotDataWriter)");
    }

    default public <T> T getItemStack(String key) {
        throw new IllegalStateException("Only for spigot purpose! (SpigotDataWriter)");
    }

    public Set<String> keySet(boolean var1);

    public Object remove(String var1);

    public Object finalCommit(String var1, Object var2);

    public Boolean getBoolean(String var1, Boolean var2);

    default public Boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public Integer getInteger(String var1, Integer var2);

    default public Integer getInteger(String key) {
        return this.getInteger(key, 0);
    }

    default public Byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    default public Byte getByte(String key, Byte def) {
        Integer n = this.getInteger(key, null);
        return n == null ? def.byteValue() : ((Number)n).byteValue();
    }

    public JSONArray getList(String var1);

    public Long getLong(String var1, Long var2);

    default public Long getLong(String key) {
        return this.getLong(key, 0L);
    }

    default public Date getDate(String key, Date def) {
        Long o = this.getLong(key, null);
        return o == null ? def : new Date(o);
    }

    default public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Double getDouble(String var1, Double var2);

    default public Double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public Float getFloat(String var1, Float var2);

    default public Float getFloat(String key) {
        return this.getFloat(key, Float.valueOf(0.0f));
    }

    default public String getString(String key, String def) {
        Object o = this.get(key);
        return o == null ? def : o + "";
    }

    default public String getString(String key) {
        return this.getString(key, null);
    }

    public <T extends Serializable> T getSerializable(String var1, Serializable var2);

    default public <T> T get(String key) {
        return this.get(key, (T)null);
    }

    default public <T> T getRaw(String key) {
        return this.get(key, null, true);
    }

    default public <T> T get(String key, T def) {
        return this.get(key, def, false);
    }

    public <T> T get(String var1, T var2, boolean var3);

    default public <T extends Enum<T>> T get(String key, Class<T> def) {
        T o = this.get(key);
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Value isn't a String. Can't search for a enum!");
        }
        String name = (String)o;
        for (Enum e : (Enum[])def.getEnumConstants()) {
            if (!e.name().equals(name)) continue;
            return (T)e;
        }
        return null;
    }

    default public void clear() {
        this.keySet(false).forEach(this::remove);
    }
}

