/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.io.JSON;

import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSONParser;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONObject;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.ParseException;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.DataMask;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BungeeJSON
extends JSONObject
implements DataMask {
    private String prefix;

    public BungeeJSON() {
        this((String)null);
    }

    public BungeeJSON(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    public BungeeJSON(Map map) {
        this(map, null);
    }

    public BungeeJSON(Map map, String prefix) {
        super(map);
        this.prefix = prefix == null ? "" : prefix;
    }

    @Override
    public String toJSONString() {
        return super.toJSONString().replace("\\\\\\\\\\\\\\\"", "\\7\"");
    }

    public static Collection<String> keySet(String prefix, Map<?, ?> map) {
        if (prefix == null) {
            prefix = "";
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<?, ?> o : map.entrySet()) {
            Map.Entry<?, ?> e = o;
            if (e.getValue() instanceof String) {
                try {
                    e.setValue(new JSONParser().parse((String)e.getValue()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Map) {
                set.addAll(BungeeJSON.keySet((prefix.isEmpty() ? "" : prefix + ".") + e.getKey(), (Map)e.getValue()));
                continue;
            }
            set.add((prefix.isEmpty() ? "" : prefix + ".") + e.getKey());
        }
        return set;
    }

    @Override
    public Set<String> keySet(boolean depth) {
        HashSet<String> data = new HashSet<String>();
        Collection<String> o = BungeeJSON.keySet("", this);
        if (depth) {
            for (String s : o) {
                if (this.prefix.isEmpty()) {
                    data.add(s);
                    continue;
                }
                if (!s.startsWith(this.prefix + ".")) continue;
                data.add(s.replace(this.prefix + ".", ""));
            }
        } else {
            for (String s : o) {
                if (this.prefix.isEmpty()) {
                    data.add(s.split("\\.")[0]);
                    continue;
                }
                if (!s.startsWith(this.prefix + ".")) continue;
                data.add(s.replace(this.prefix + ".", "").split("\\.")[0]);
            }
        }
        return data;
    }

    @Override
    public Object finalCommit(String key, Object value) {
        if (value instanceof Serializable) {
            this.write((Serializable)value, key);
            return null;
        }
        BungeeJSON section = this.getOrCreateSection(this.k(key));
        if (section == this) {
            return super.put(key, value);
        }
        return section.put(this.getLastKey(key), value);
    }

    private static Map<?, ?> getSection(Map<?, ?> map, String key) {
        int i = key.indexOf(".");
        if (i == -1) {
            return map;
        }
        String first = key.substring(0, i);
        Object o = map.get(first);
        if (o == null) {
            o = map.get(BungeeJSON.removeLastKey(key));
            if (o == null) {
                o = map.get(key);
            }
            if (o == null) {
                return null;
            }
            if (!(o instanceof Map)) {
                return map;
            }
            return BungeeJSON.getSection((Map)o, key.substring(i + 1));
        }
        if (!(o instanceof Map)) {
            return map;
        }
        return BungeeJSON.getSection((Map)o, key.substring(i + 1));
    }

    private BungeeJSON getOrCreateSection(String key) {
        int i = key.indexOf(".");
        if (i == -1) {
            return this;
        }
        String first = key.substring(0, i);
        Object o = super.get(first);
        if (o == null) {
            o = new BungeeJSON();
            super.put(first, o);
        }
        return ((BungeeJSON)o).getOrCreateSection(key.substring(i + 1));
    }

    public void write(Serializable s, String key) {
        String oldPrefix = this.prefix;
        this.prefix = this.k(key);
        s.write(this);
        this.prefix = oldPrefix;
    }

    public void read(Serializable s, String key) throws Exception {
        String oldPrefix = this.prefix;
        this.prefix = this.k(key);
        s.read(this);
        this.prefix = oldPrefix;
    }

    private String k(String key) {
        return (this.prefix.isEmpty() ? "" : this.prefix + ".") + key;
    }

    private String getLastKey(String key) {
        if (!key.contains(".")) {
            return key;
        }
        String[] a = key.split("\\.", -1);
        return a[a.length - 1];
    }

    private static String removeLastKey(String key) {
        if (!key.contains(".")) {
            return key;
        }
        return key.substring(0, key.lastIndexOf("."));
    }

    @Override
    public Object remove(String key) {
        return super.remove(key);
    }

    @Override
    public <T extends Serializable> T getSerializable(String key, Serializable serializable) {
        try {
            this.read(serializable, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)serializable;
    }

    @Override
    public Boolean getBoolean(String key, Boolean def) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? def : b;
    }

    @Override
    public Integer getInteger(String key, Integer def) {
        Number i = (Number)this.get(key);
        return i == null ? def : Integer.valueOf(i.intValue());
    }

    @Override
    public JSONArray getList(String key) {
        List i = (List)this.get(key);
        if (i == null) {
            return new JSONArray();
        }
        if (i instanceof JSONArray) {
            return (JSONArray)i;
        }
        JSONArray array = new JSONArray();
        array.addAll(i);
        return array;
    }

    @Override
    public Long getLong(String key, Long def) {
        Number d = (Number)this.get(key);
        return d == null ? def : Long.valueOf(d.longValue());
    }

    @Override
    public Double getDouble(String key, Double def) {
        Number d = (Number)this.get(key);
        return d == null ? def : Double.valueOf(d.doubleValue());
    }

    @Override
    public Float getFloat(String key, Float def) {
        Number d = (Number)this.get(key);
        return d == null ? def : Float.valueOf(d.floatValue());
    }

    @Override
    public <T> T get(String key, T def, boolean raw) {
        Map<?, ?> map = BungeeJSON.getSection(this, this.k(key));
        if (map == null) {
            return null;
        }
        Object o = map.get(this.getLastKey(key));
        if (o == null && map == this) {
            o = map.get(this.prefix.isEmpty() ? key : this.prefix);
            if (o instanceof String) {
                try {
                    o = new JSONParser().parse((String)o);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (o instanceof BungeeJSON) {
                o = ((BungeeJSON)o).get((Object)key);
            }
        }
        if (!raw) {
            long l;
            if (o instanceof Long && (l = ((Long)o).longValue()) <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (T)Integer.valueOf(Math.toIntExact(l));
            }
            if (o instanceof String) {
                try {
                    Object result = new JSONParser().parse((String)o);
                    if (result != null) {
                        o = result;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (o instanceof JSONObject) {
                return (T)new BungeeJSON((Map)((JSONObject)o));
            }
        }
        return (T)(o == null ? def : o);
    }
}

